/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zegoexpress.internal;

import android.os.Handler;
import android.os.Looper;
import im.zego.zegoexpress.ZegoAudioEffectPlayer;
import im.zego.zegoexpress.callback.IZegoAudioEffectPlayerEventHandler;
import im.zego.zegoexpress.callback.IZegoAudioEffectPlayerLoadResourceCallback;
import im.zego.zegoexpress.callback.IZegoAudioEffectPlayerSeekToCallback;
import im.zego.zegoexpress.entity.ZegoAudioEffectPlayConfig;
import im.zego.zegoexpress.internal.ZegoAudioEffectPlayerJniAPI;
import im.zego.zegoexpress.internal.ZegoExpressEngineInternalImpl;
import im.zego.zegoexpress.utils.ZegoDebugLevel;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ZegoAudioEffectPlayerInternalImpl
extends ZegoAudioEffectPlayer {
    public static Handler mUIHandler = new Handler(Looper.getMainLooper());
    public static ConcurrentHashMap<ZegoAudioEffectPlayer, IdxAndHandler> audioEffectPlayerToIdxAndEventhandler = new ConcurrentHashMap();

    public static ZegoAudioEffectPlayer createAudioEffectPlayer() {
        int index = ZegoAudioEffectPlayerJniAPI.createZegoAudioEffectPlayerJni();
        if (index >= 0) {
            ZegoAudioEffectPlayerInternalImpl zegoAudioEffectPlayer = new ZegoAudioEffectPlayerInternalImpl();
            IdxAndHandler idxAndHandler = new IdxAndHandler(index);
            idxAndHandler.seekToTimeCallbackHashMap = new ConcurrentHashMap();
            idxAndHandler.loadResourceCallbackHashMap = new ConcurrentHashMap();
            audioEffectPlayerToIdxAndEventhandler.put(zegoAudioEffectPlayer, idxAndHandler);
            return zegoAudioEffectPlayer;
        }
        ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.ERROR, 14, "createAudioEffectPlayer", 1014004, new Object[0]);
        return null;
    }

    public static void destroyAudioEffectPlayer(ZegoAudioEffectPlayer audioEffectPlayer) {
        Iterator<Map.Entry<ZegoAudioEffectPlayer, IdxAndHandler>> it = audioEffectPlayerToIdxAndEventhandler.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ZegoAudioEffectPlayer, IdxAndHandler> item = it.next();
            if (item.getKey() != audioEffectPlayer) continue;
            item.getValue().eventHandler = null;
            item.getValue().loadResourceCallbackHashMap = null;
            Iterator<Map.Entry<Integer, IZegoAudioEffectPlayerSeekToCallback>> itSeekToTimeCallbackHashMap = item.getValue().seekToTimeCallbackHashMap.entrySet().iterator();
            while (itSeekToTimeCallbackHashMap.hasNext()) {
                itSeekToTimeCallbackHashMap.remove();
            }
            item.getValue().seekToTimeCallbackHashMap = null;
            int idx = item.getValue().kAudioEffectPlayerIdx;
            int errorCode = ZegoAudioEffectPlayerJniAPI.destroyAudioEffectPlayerJni(idx);
            it.remove();
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 14, "destroyAudioEffectPlayer", errorCode, new Object[0]);
        }
    }

    @Override
    public void setEventHandler(IZegoAudioEffectPlayerEventHandler handler) {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            idxAndHandler.eventHandler = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void loadResource(int audioEffectID, String path, IZegoAudioEffectPlayerLoadResourceCallback callback) {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler == null) return;
        int seq = ZegoAudioEffectPlayerJniAPI.loadResourceJni(audioEffectID, idxAndHandler.kAudioEffectPlayerIdx, path);
        Class<ZegoAudioEffectPlayerInternalImpl> clazz = ZegoAudioEffectPlayerInternalImpl.class;
        synchronized (ZegoAudioEffectPlayerInternalImpl.class) {
            idxAndHandler.loadResourceCallbackHashMap.put(seq, callback);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void unloadResource(int audioEffectID) {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoAudioEffectPlayerJniAPI.unloadResource(audioEffectID, idxAndHandler.kAudioEffectPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 14, "unloadResource", errorCode, new Object[0]);
        }
    }

    @Override
    public void start(int audioEffectID, String path, ZegoAudioEffectPlayConfig config) {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoAudioEffectPlayerJniAPI.start(audioEffectID, path, config, idxAndHandler.kAudioEffectPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 14, "start", errorCode, new Object[0]);
        }
    }

    @Override
    public void stop(int audioEffectID) {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoAudioEffectPlayerJniAPI.stop(audioEffectID, idxAndHandler.kAudioEffectPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 14, "stop", errorCode, new Object[0]);
        }
    }

    @Override
    public void pause(int audioEffectID) {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoAudioEffectPlayerJniAPI.pause(audioEffectID, idxAndHandler.kAudioEffectPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 14, "pause", errorCode, new Object[0]);
        }
    }

    @Override
    public void resume(int audioEffectID) {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoAudioEffectPlayerJniAPI.resume(audioEffectID, idxAndHandler.kAudioEffectPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 14, "resume", errorCode, new Object[0]);
        }
    }

    @Override
    public void stopAll() {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoAudioEffectPlayerJniAPI.stopAll(idxAndHandler.kAudioEffectPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 14, "stopAll", errorCode, new Object[0]);
        }
    }

    @Override
    public void pauseAll() {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoAudioEffectPlayerJniAPI.pauseAll(idxAndHandler.kAudioEffectPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 14, "pauseAll", errorCode, new Object[0]);
        }
    }

    @Override
    public void resumeAll() {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoAudioEffectPlayerJniAPI.resumeAll(idxAndHandler.kAudioEffectPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 14, "resumeAll", errorCode, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void seekTo(int audioEffectID, long millisecond, IZegoAudioEffectPlayerSeekToCallback callback) {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler == null) return;
        int seq = ZegoAudioEffectPlayerJniAPI.seekToJni(audioEffectID, idxAndHandler.kAudioEffectPlayerIdx, millisecond);
        Class<ZegoAudioEffectPlayerInternalImpl> clazz = ZegoAudioEffectPlayerInternalImpl.class;
        synchronized (ZegoAudioEffectPlayerInternalImpl.class) {
            idxAndHandler.seekToTimeCallbackHashMap.put(seq, callback);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setVolume(int audioEffectID, int volume) {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoAudioEffectPlayerJniAPI.setVolume(audioEffectID, volume, idxAndHandler.kAudioEffectPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 14, "setVolume", errorCode, new Object[0]);
        }
    }

    @Override
    public void setVolumeAll(int volume) {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoAudioEffectPlayerJniAPI.setVolumeAll(volume, idxAndHandler.kAudioEffectPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 14, "setVolumeAll", errorCode, new Object[0]);
        }
    }

    @Override
    public long getTotalDuration(int audioEffectID) {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            return ZegoAudioEffectPlayerJniAPI.getTotalDuration(audioEffectID, idxAndHandler.kAudioEffectPlayerIdx);
        }
        return -1L;
    }

    @Override
    public long getCurrentProgress(int audioEffectID) {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            return ZegoAudioEffectPlayerJniAPI.getCurrentProgress(audioEffectID, idxAndHandler.kAudioEffectPlayerIdx);
        }
        return -1L;
    }

    @Override
    public int getIndex() {
        IdxAndHandler idxAndHandler = audioEffectPlayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            return idxAndHandler.kAudioEffectPlayerIdx;
        }
        return -1;
    }

    static class IdxAndHandler {
        int kAudioEffectPlayerIdx;
        ConcurrentHashMap<Integer, IZegoAudioEffectPlayerSeekToCallback> seekToTimeCallbackHashMap;
        ConcurrentHashMap<Integer, IZegoAudioEffectPlayerLoadResourceCallback> loadResourceCallbackHashMap;
        IZegoAudioEffectPlayerEventHandler eventHandler;

        IdxAndHandler(int idx) {
            this.kAudioEffectPlayerIdx = idx;
        }
    }
}

