package im.zego.zegoexpress.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import im.zego.zegoexpress.ZegoAudioEffectPlayer;
import im.zego.zegoexpress.callback.IZegoAudioEffectPlayerEventHandler;
import im.zego.zegoexpress.callback.IZegoAudioEffectPlayerLoadResourceCallback;
import im.zego.zegoexpress.callback.IZegoAudioEffectPlayerSeekToCallback;
import im.zego.zegoexpress.constants.ZegoAudioEffectPlayState;
import im.zego.zegoexpress.utils.ZegoDebugLevel;

import static im.zego.zegoexpress.internal.ZegoAudioEffectPlayerInternalImpl.audioEffectPlayerToIdxAndEventhandler;

class ZegoAudioEffectPlayerJniCallback {
    public static void onAudioEffectPlayerPlayStateUpdate(final int audio_effect_id, int state, final int error_code, int instance_index) {
        ZegoExpressEngineInternalImpl.printDebugInfo((error_code == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoExpressEngineInternalImpl.ZegoInnerModule.AUDIO_EFFECT_PLAYER, "onAudioEffectPlayerPlayStateUpdate", error_code);

        final ZegoAudioEffectPlayState zegoAudioEffectPlayerState = ZegoAudioEffectPlayState.values()[state];

        final ConcurrentHashMap<ZegoAudioEffectPlayer, ZegoAudioEffectPlayerInternalImpl.IdxAndHandler> mAudioEffectPlayerToIdxAndEventhandler = audioEffectPlayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoAudioEffectPlayer, ZegoAudioEffectPlayerInternalImpl.IdxAndHandler> item : mAudioEffectPlayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kAudioEffectPlayerIdx == instance_index) {
                final IZegoAudioEffectPlayerEventHandler iZegoAudioEffectPlayerEventHandler = item.getValue().eventHandler;
                if (iZegoAudioEffectPlayerEventHandler == null) {
                    //todo: 这里需要增加日志打印
                    return;
                } else {
                    ZegoAudioEffectPlayerInternalImpl.mUIHandler.post(new Runnable() {
                        @Override
                        public void run() {
                            iZegoAudioEffectPlayerEventHandler.onAudioEffectPlayStateUpdate(item.getKey(), audio_effect_id, zegoAudioEffectPlayerState, error_code);
                        }
                    });
                }
            }
        }

    }

    public static void onSeekToTimeCallback(final int seq, int idx, final int errorcode) {
        synchronized (ZegoAudioEffectPlayerInternalImpl.class) {
            ZegoExpressEngineInternalImpl.printDebugInfo((errorcode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.AUDIO_EFFECT_PLAYER, "onSeekToTimeCallback", errorcode);

            final ConcurrentHashMap<ZegoAudioEffectPlayer, ZegoAudioEffectPlayerInternalImpl.IdxAndHandler> mAudioEffectPlayerToIdxAndEventhandler = audioEffectPlayerToIdxAndEventhandler;
            for (final Map.Entry<ZegoAudioEffectPlayer, ZegoAudioEffectPlayerInternalImpl.IdxAndHandler> item : mAudioEffectPlayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kAudioEffectPlayerIdx == idx) {
                    final IZegoAudioEffectPlayerSeekToCallback seekToTimeCallback = item.getValue().seekToTimeCallbackHashMap.get(seq);
                    if (seekToTimeCallback == null) {
                        //todo: 这里需要增加日志打印
                        return;
                    } else {
                        ZegoAudioEffectPlayerInternalImpl.mUIHandler.post(new Runnable() {
                            @Override
                            public void run() {
                                seekToTimeCallback.onSeekToCallback(errorcode);
                                item.getValue().seekToTimeCallbackHashMap.remove(seq);
                            }
                        });
                    }
                }
            }
        }
    }

    public static void onLoadResourceCallback(final int seq, int idx, final int errorcode) {
        synchronized (ZegoAudioEffectPlayerInternalImpl.class) {
            ZegoExpressEngineInternalImpl.printDebugInfo((errorcode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                    ZegoExpressEngineInternalImpl.ZegoInnerModule.AUDIO_EFFECT_PLAYER, "onLoadResourceCallback", errorcode);
            final ConcurrentHashMap<ZegoAudioEffectPlayer, ZegoAudioEffectPlayerInternalImpl.IdxAndHandler> mAudioEffectplayerToIdxAndEventhandler = audioEffectPlayerToIdxAndEventhandler;
            for (final Map.Entry<ZegoAudioEffectPlayer, ZegoAudioEffectPlayerInternalImpl.IdxAndHandler> item : mAudioEffectplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kAudioEffectPlayerIdx == idx) {
                    final IZegoAudioEffectPlayerLoadResourceCallback iZegoAudioEffectPlayerLoadResourceCallback = item.getValue().loadResourceCallbackHashMap.get(seq);
                    if (iZegoAudioEffectPlayerLoadResourceCallback == null) {
                        //todo: 这里需要增加日志打印
                        return;
                    } else {
                        ZegoAudioEffectPlayerInternalImpl.mUIHandler.post(new Runnable() {
                            @Override
                            public void run() {
                                iZegoAudioEffectPlayerLoadResourceCallback.onLoadResourceCallback(errorcode);
                                item.getValue().loadResourceCallbackHashMap.remove(seq);
                            }
                        });
                    }
                }

            }
        }
    }
}
