package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

/**
 * Advanced room configuration
 *
 * Configure maximum number of users in the room and authentication token, etc.
 */
public class ZegoRoomConfig {

    /** The maximum number of users in the room, Passing 0 means unlimited, the default is unlimited. */
    public int maxMemberCount;

    /** Whether to enable the user in and out of the room callback notification [onRoomUserUpdate], the default is off. If developers need to use ZEGO Room user notifications, make sure that each user who login sets this flag to true */
    public boolean isUserStatusNotify;

    /** The token issued by the developer's business server is used to ensure security. The generation rules are detailed in Room Login Authentication Description https://doc-en.zego.im/en/3881.html Default is empty string, that is, no authentication */
    public String token;

    public ZegoRoomConfig(){
        maxMemberCount = 0;
        isUserStatusNotify = false;
        token = "";
    }

}
