package im.zego.zegoexpress.constants;

/** Voice changer preset value */
public enum ZegoVoiceChangerPreset {
    /** No Voice changer */
    NONE(0),
    /** Male voice becomes child's voice */
    MEN_TO_CHILD(1),
    /** male to female voices */
    MEN_TO_WOMEN(2),
    /** Female voice becomes child's voice */
    WOMEN_TO_CHILD(3),
    /** Female Voice to Male Voice */
    WOMEN_TO_MEN(4);

    private int value;

    private ZegoVoiceChangerPreset(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoVoiceChangerPreset getZegoVoiceChangerPreset(int value) {
        try {

            if (NONE.value == value) {
                return NONE;
            }

            if (MEN_TO_CHILD.value == value) {
                return MEN_TO_CHILD;
            }

            if (MEN_TO_WOMEN.value == value) {
                return MEN_TO_WOMEN;
            }

            if (WOMEN_TO_CHILD.value == value) {
                return WOMEN_TO_CHILD;
            }

            if (WOMEN_TO_MEN.value == value) {
                return WOMEN_TO_MEN;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }
}