package im.zego.zegoexpress.callback;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

public abstract class IZegoMediaPlayerEventHandler {

    /**
     * The callback triggered when the state of the media player changes.
     *
     * @param mediaPlayer Callback player object
     * @param state Media player status
     * @param errorCode Error code, please refer to the Error Codes https://doc-en.zego.im/en/308.html for details
     */
    public void onMediaPlayerStateUpdate(ZegoMediaPlayer mediaPlayer, ZegoMediaPlayerState state, int errorCode){

    }

    /**
     * The callback triggered when the network status of the media player changes.
     *
     * @param mediaPlayer Callback player object
     * @param networkEvent Network status event
     */
    public void onMediaPlayerNetworkEvent(ZegoMediaPlayer mediaPlayer, ZegoMediaPlayerNetworkEvent networkEvent){

    }

    /**
     * The callback to report the current playback progress of the media player.
     *
     * @param mediaPlayer Callback player object
     * @param millisecond Progress in milliseconds
     */
    public void onMediaPlayerPlayingProgress(ZegoMediaPlayer mediaPlayer, long millisecond){

    }

}

