package im.zego.zegoexpress.callback;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

public abstract class IZegoCustomVideoCaptureHandler {

    /**
     * The callback triggered when the SDK is ready to receive captured video data. Only those video data that are sent to the SDK after this callback is received are valid.
     *
     * @param channel Publishing stream channel
     */
    public void onStart(ZegoPublishChannel channel){

    }

    /**
     * The callback triggered when SDK stops receiving captured video data.
     *
     * @param channel Publishing stream channel
     */
    public void onStop(ZegoPublishChannel channel){

    }

    /**
     * SDK detects network changes and informs developers that it needs to do traffic control
     * In the case of custom video capture by sending encoded data, the SDK cannot know the external encoding configuration, so the traffic control operation needs to be completed by the developer.
     * The SDK will notify the developer of the recommended value of the video configuration according to the current network situation, and the developer needs to modify the encoder configuration by himself to ensure the smoothness of video transmission
     * Please do not perform time-consuming operations in this callback. If you need to perform time-consuming operations, please switch threads
     *
     * @param trafficControlInfo traffic control info
     * @param channel Publishing stream channel
     */
    public void onEncodedDataTrafficControl(ZegoTrafficControlInfo trafficControlInfo, ZegoPublishChannel channel){

    }

}

