package im.zego.zegoexpress.callback;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

public abstract class IZegoAudioDataHandler {

    /**
     * The callback for obtaining the audio data captured by the local microphone.
     *
     * In non-custom audio capture mode, the SDK capture the microphone's sound, but the developer may also need to get a copy of the The audio data captured by the SDK SDK is available through this callback.
     * On the premise of calling [setAudioDataHandler] to set the listener callback, after calling [enableAudioDataCallback] to set the mask 0x01, this callback will be triggered only when it is in the publishing stream state.
     *
     * @param data audio data of pcm format
     * @param dataLength length of data
     * @param param param of audio frame
     */
    public void onCapturedAudioData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param){

    }

    /**
     * The callback for obtaining the audio data of all the remote streams pulled.
     *
     * This method will callback all of the remote user's audio mix data. This callback can be used for that you needs to fetch all the playing streams to proccess.
     * On the premise of calling [setAudioDataHandler] to set the listener callback, after calling [enableAudioDataCallback] to set the mask 0x02, this callback will be triggered only when it is in the playing stream state.
     *
     * @deprecated This interface is deprecated, please use the [onPlaybackAudioData] interface
     * @param data audio data of pcm format
     * @param dataLength length of data
     * @param param param of audio frame
     */
    @Deprecated
    public void onRemoteAudioData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param){

    }

    /**
     * The callback for obtaining the audio data of all the streams playback by SDK.
     *
     * This method will callback all the mixed audio data to be playback. This callback can be used for that you needs to fetch all the mixed audio data to be playback to proccess.
     * On the premise of calling [setAudioDataHandler] to set the listener callback, after calling [enableAudioDataCallback] to set the mask 0x02, this callback will be triggered only when it is in the SDK inner audio and video engine started(called the [startPreivew] or [startPlayingStream] or [startPublishingStream]).
     * When the engine is started in the non-playing stream state or the media player is not used to play the media file, the audio data to be called back is muted audio data.
     *
     * @param data audio data of pcm format
     * @param dataLength length of data
     * @param param param of audio frame
     */
    public void onPlaybackAudioData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param){

    }

    /**
     * The callback for obtaining the mixed audio data. Such mixed auido data are generated by the SDK by mixing the audio data of all the remote streams pulled and the auido data captured locally.
     *
     * The audio data of all playing data is mixed with the data captured by the local microphone before it is sent to the loudspeaker, and calleback out in this way.
     * On the premise of calling [setAudioDataHandler] to set the listener callback, after calling [enableAudioDataCallback] to set the mask 0x04, this callback will be triggered only when it is in the publishing stream state or playing stream state.
     *
     * @param data audio data of pcm format
     * @param dataLength length of data
     * @param param param of audio frame
     */
    public void onMixedAudioData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param){

    }

}

