package im.zego.zegoexpress.callback;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import android.app.Application;
import android.graphics.*;

public abstract class IZegoAudioMixingHandler {

    /**
     * The callback for copying audio data to the SDK for audio mixing. This API should be used together with enableAudioMixing.
     *
     * Supports 16k 32k 44.1k 48k sample rate, mono or dual channel, 16-bit deep PCM audio data
     * This callback is a high frequency callback. To ensure the quality of the mixing data, please do not handle time-consuming operations in this callback
     *
     * @param expectedDataLength Expected length of incoming audio mixing data
     * @return Data to be mixed
     */
    public ZegoAudioMixingData onAudioMixingCopyData(int expectedDataLength){
        return null;
    }

}

