/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.hardwaremonitor;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Debug;
import java.lang.reflect.Method;

public class ZegoMEMUtils {
    public static long[] getMemInfo() {
        long[] memInfo = new long[4];
        try {
            Class<?> procClazz = Class.forName("android.os.Process");
            Class[] paramTypes = new Class[]{String.class, String[].class, long[].class};
            Method readProclines = procClazz.getMethod("readProcLines", paramTypes);
            Object[] args = new Object[3];
            String[] memInfoFields = new String[]{"MemTotal:", "MemFree:", "Buffers:", "Cached:"};
            long[] memInfoSizes = new long[memInfoFields.length];
            memInfoSizes[0] = 30L;
            memInfoSizes[1] = -30L;
            args[0] = new String("/proc/meminfo");
            args[1] = memInfoFields;
            args[2] = memInfoSizes;
            if (null != readProclines) {
                readProclines.invoke(null, args);
                for (int i = 0; i < memInfoSizes.length; ++i) {
                    memInfo[i] = memInfoSizes[i] / 1024L;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return memInfo;
    }

    public static long[] getPrivDirty(Context context, int pid) {
        ActivityManager mAm = (ActivityManager)context.getSystemService("activity");
        int[] pids = new int[]{pid};
        Debug.MemoryInfo[] memoryInfoArray = mAm.getProcessMemoryInfo(pids);
        Debug.MemoryInfo pidMemoryInfo = memoryInfoArray[0];
        long[] value = new long[]{pidMemoryInfo.nativePrivateDirty, pidMemoryInfo.dalvikPrivateDirty, pidMemoryInfo.getTotalPrivateDirty()};
        return value;
    }

    public static long[] getPSS(Context context, int pid) {
        long[] value = new long[3];
        if (pid >= 0) {
            int[] pids = new int[]{pid};
            ActivityManager mAm = (ActivityManager)context.getSystemService("activity");
            Debug.MemoryInfo[] memoryInfoArray = mAm.getProcessMemoryInfo(pids);
            Debug.MemoryInfo pidMemoryInfo = memoryInfoArray[0];
            value[0] = pidMemoryInfo.nativePss;
            value[1] = pidMemoryInfo.dalvikPss;
            value[2] = pidMemoryInfo.getTotalPss();
        } else {
            value[0] = 0L;
            value[1] = 0L;
            value[2] = 0L;
        }
        return value;
    }

    public static long[] getHeap() {
        long[] value = new long[6];
        long[] nativeValue = ZegoMEMUtils.getHeapNative();
        long[] dalvikValue = ZegoMEMUtils.getHeapDalvik();
        value[0] = nativeValue[0];
        value[1] = nativeValue[1];
        value[2] = dalvikValue[0];
        value[3] = dalvikValue[1];
        value[4] = nativeValue[0] + dalvikValue[0];
        value[5] = nativeValue[1] + dalvikValue[1];
        return value;
    }

    public static long[] getHeapNative() {
        long[] value = new long[]{Debug.getNativeHeapSize() >> 10, Debug.getNativeHeapAllocatedSize() >> 10};
        return value;
    }

    public static long[] getHeapDalvik() {
        long[] value = new long[]{Runtime.getRuntime().totalMemory() >> 10, Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() >> 10};
        return value;
    }
}

