package im.zego.zegoexpress.constants;

/** Player video layer. */
public enum ZegoPlayerVideoLayer {
    /** The layer to be played depends on the network status */
    AUTO(0),
    /** Play the base layer (small resolution) */
    BASE(1),
    /** Play the extend layer (big resolution) */
    BASE_EXTEND(2);

    private int value;

    private ZegoPlayerVideoLayer(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoPlayerVideoLayer getZegoPlayerVideoLayer(int value) {
        try {

            if (AUTO.value == value) {
                return AUTO;
            }

            if (BASE.value == value) {
                return BASE;
            }

            if (BASE_EXTEND.value == value) {
                return BASE_EXTEND;
            }

        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
        return null;
    }
}