package im.zego.zegoexpress.internal;

import android.os.Handler;
import android.os.Looper;

import im.zego.zegoexpress.ZegoMediaPlayer;
import im.zego.zegoexpress.callback.IZegoMediaPlayerVideoHandler;
import im.zego.zegoexpress.constants.ZegoAudioChannel;
import im.zego.zegoexpress.constants.ZegoAudioSampleRate;
import im.zego.zegoexpress.constants.ZegoMediaPlayerNetworkEvent;
import im.zego.zegoexpress.constants.ZegoMediaPlayerState;
import im.zego.zegoexpress.constants.ZegoVideoFrameFormat;
import im.zego.zegoexpress.entity.ZegoAudioFrameParam;
import im.zego.zegoexpress.entity.ZegoCanvas;
import im.zego.zegoexpress.entity.ZegoVideoFrameParam;
import im.zego.zegoexpress.callback.IZegoMediaPlayerAudioHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerEventHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerLoadResourceCallback;
import im.zego.zegoexpress.callback.IZegoMediaPlayerSeekToCallback;
import im.zego.zegoexpress.utils.ZegoCallbackHelpers;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class ZegoMediaPlayerInternalImpl extends ZegoMediaPlayer{

    public static Handler mUIHandler = new Handler(Looper.getMainLooper());




    /* 在 ZegoMediaplayerJni 里同时管理对于JNI的调用回调与 Mediaplayer 多实例的管理*/

    static class IdxAndHandler {
        int kMediaPlayerIdx;
        HashMap<Integer, IZegoMediaPlayerSeekToCallback> seekToTimeCallbackHashMap;
        IZegoMediaPlayerLoadResourceCallback loadResourceCallback;
        IZegoMediaPlayerEventHandler eventHandler;
        IZegoMediaPlayerAudioHandler audioHandler;
        Object videoHandler;

        IdxAndHandler(int idx) {
            this.kMediaPlayerIdx = idx;
        }
    }

    public static HashMap<ZegoMediaPlayer, IdxAndHandler> mediaplayerToIdxAndEventhandler = new HashMap<>();

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void setEventHandler(IZegoMediaPlayerEventHandler handler) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            idxAndHandler.eventHandler = handler;
        }
    }


    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER


    // opt_content_start: audio_or_video = video; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void setVideoHandler(IZegoMediaPlayerVideoHandler handler, ZegoVideoFrameFormat frameFormat) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            idxAndHandler.videoHandler = handler;
            if (handler == null) {
                ZegoMediaPlayerJniAPI.enableVideoDataJni(frameFormat.value(), false, idxAndHandler.kMediaPlayerIdx);
            } else {
                ZegoMediaPlayerJniAPI.enableVideoDataJni(frameFormat.value(), true, idxAndHandler.kMediaPlayerIdx);
            }
        }
    }
    // opt_content_end: audio_or_video = video; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER


    // opt_content_start: audio_or_video = audio; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void setAudioHandler(IZegoMediaPlayerAudioHandler handler) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            idxAndHandler.audioHandler = handler;
            if (handler == null) {
                ZegoMediaPlayerJniAPI.enableAudioDataJni(false, idxAndHandler.kMediaPlayerIdx);
            } else {
                ZegoMediaPlayerJniAPI.enableAudioDataJni(true, idxAndHandler.kMediaPlayerIdx);
            }
        }
    }
    // opt_content_end: audio_or_video = audio; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void loadResource(String path, IZegoMediaPlayerLoadResourceCallback callback) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.loadResourceJni(idxAndHandler.kMediaPlayerIdx, path);
            idxAndHandler.loadResourceCallback = callback;
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public int getIndex() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            return idxAndHandler.kMediaPlayerIdx;
        }
        return 0;
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER


    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void start() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.startJni(idxAndHandler.kMediaPlayerIdx);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void stop() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.stopJni(idxAndHandler.kMediaPlayerIdx);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void pause() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.pauseJni(idxAndHandler.kMediaPlayerIdx);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void resume() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.resumeJni(idxAndHandler.kMediaPlayerIdx);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void seekTo(long millisecond, IZegoMediaPlayerSeekToCallback callback) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int seq = ZegoMediaPlayerJniAPI.seekToJni(idxAndHandler.kMediaPlayerIdx, millisecond);
            synchronized (ZegoMediaPlayerInternalImpl.class) {
                idxAndHandler.seekToTimeCallbackHashMap.put(seq, callback);
            }
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER


    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void enableRepeat(boolean enable) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.enableRepeatJni(idxAndHandler.kMediaPlayerIdx, enable);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void enableAux(boolean enable) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.enableAuxJni(idxAndHandler.kMediaPlayerIdx, enable);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void muteLocal(boolean mute) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.muteLocalJni(idxAndHandler.kMediaPlayerIdx, mute);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void setPlayerCanvas(ZegoCanvas canvas) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            if (canvas != null) {
                ZegoMediaPlayerJniAPI.setPlayerCanvasJni(idxAndHandler.kMediaPlayerIdx, canvas.view, canvas.viewMode.value(), canvas.backgroundColor);
            } else {
                ZegoMediaPlayerJniAPI.setPlayerCanvasJni(idxAndHandler.kMediaPlayerIdx, null, 0, 0);

            }
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void setVolume(int volume) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.setVolumeJni(idxAndHandler.kMediaPlayerIdx, volume);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public int getVolume() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            return ZegoMediaPlayerJniAPI.getVolumeJni(idxAndHandler.kMediaPlayerIdx);
        }
        return -1;
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public void setProgressInterval(long millisecond) {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoMediaPlayerJniAPI.setProgressIntervalJni(idxAndHandler.kMediaPlayerIdx, millisecond);
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public long getTotalDuration() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            return ZegoMediaPlayerJniAPI.getTotalDurationJni(idxAndHandler.kMediaPlayerIdx);
        }
        return -1;
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public long getCurrentProgress() {
        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            return ZegoMediaPlayerJniAPI.getCurrentProgressJni(idxAndHandler.kMediaPlayerIdx);
        }
        return -1;
    }

    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER


    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static ZegoMediaPlayer createMediaPlayer() {
        int index = ZegoMediaPlayerJniAPI.createMediaPlayerJni();
        if (index >= 0) {
            ZegoMediaPlayer zegoMediaPlayer = new ZegoMediaPlayerInternalImpl();
            IdxAndHandler idxAndHandler = new IdxAndHandler(index);
            idxAndHandler.seekToTimeCallbackHashMap = new HashMap<>();
            mediaplayerToIdxAndEventhandler.put(zegoMediaPlayer, idxAndHandler);
            return zegoMediaPlayer;
        } else {
            return null;
        }
    }



    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static void destroyMediaPlayer(ZegoMediaPlayer mediaplayer) {
        synchronized (ZegoMediaPlayerInternalImpl.class) {
            for (Iterator<Map.Entry<ZegoMediaPlayer, IdxAndHandler>> it = mediaplayerToIdxAndEventhandler.entrySet().iterator(); it.hasNext(); ) {
                Map.Entry<ZegoMediaPlayer, IdxAndHandler> item = it.next();
                if (item.getKey() == mediaplayer) {
                    item.getValue().videoHandler = null;
                    item.getValue().audioHandler = null;
                    item.getValue().eventHandler = null;
                    item.getValue().loadResourceCallback = null;
                    Iterator<Map.Entry<Integer, IZegoMediaPlayerSeekToCallback>> itSeekToTimeCallbackHashMap = item.getValue().seekToTimeCallbackHashMap.entrySet().iterator();
                    for (; itSeekToTimeCallbackHashMap.hasNext(); ) {
                        itSeekToTimeCallbackHashMap.remove();
                    }
                    item.getValue().seekToTimeCallbackHashMap = null;
                    int idx = item.getValue().kMediaPlayerIdx;
                    ZegoMediaPlayerJniAPI.destroyMediaPlayerJni(idx);
                    it.remove();
                }
            }
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static void destroyAllMediaPlayer() {
        synchronized (ZegoMediaPlayerInternalImpl.class) {
            for (Iterator<Map.Entry<ZegoMediaPlayer, IdxAndHandler>> it = mediaplayerToIdxAndEventhandler.entrySet().iterator(); it.hasNext(); ) {
                Map.Entry<ZegoMediaPlayer, IdxAndHandler> item = it.next();
                item.getValue().videoHandler = null;
                item.getValue().audioHandler = null;
                item.getValue().eventHandler = null;
                item.getValue().loadResourceCallback = null;
                Iterator<Map.Entry<Integer, IZegoMediaPlayerSeekToCallback>> itSeekToTimeCallbackHashMap = item.getValue().seekToTimeCallbackHashMap.entrySet().iterator();
                for (; itSeekToTimeCallbackHashMap.hasNext(); ) {
                    itSeekToTimeCallbackHashMap.remove();
                }
                item.getValue().seekToTimeCallbackHashMap = null;
                int idx = item.getValue().kMediaPlayerIdx;
                ZegoMediaPlayerJniAPI.destroyMediaPlayerJni(idx);
                it.remove();
            }
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public ZegoMediaPlayerState getCurrentState() {

        final IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int state = ZegoMediaPlayerJniAPI.getCurrentStateJni(idxAndHandler.kMediaPlayerIdx);
            final ZegoMediaPlayerState zegoMediaPlayerState;
            if (state == ZegoMediaPlayerState.NO_PLAY.value()) {
                zegoMediaPlayerState = ZegoMediaPlayerState.NO_PLAY;
            } else if (state == ZegoMediaPlayerState.PLAYING.value()) {
                zegoMediaPlayerState = ZegoMediaPlayerState.PLAYING;
            } else if (state == ZegoMediaPlayerState.PAUSING.value()) {
                zegoMediaPlayerState = ZegoMediaPlayerState.PAUSING;
            } else if (state == ZegoMediaPlayerState.PLAY_ENDED.value()) {
                zegoMediaPlayerState = ZegoMediaPlayerState.PLAY_ENDED;
            } else {
                zegoMediaPlayerState = ZegoMediaPlayerState.NO_PLAY;
            }
            return zegoMediaPlayerState;
        }
        return ZegoMediaPlayerState.NO_PLAY;
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER


}

