package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

/**
 * Video config
 *
 * developer can use the built-in presets of the SDK to change the parameters of the voice changer
 */
public class ZegoVoiceChangerParam {

    /** pitch */
    public float pitch;

    /**
     * Create voice changer param configuration with preset enumeration values
     */
    public ZegoVoiceChangerParam(ZegoVoiceChangerPreset preset){
        if (preset == ZegoVoiceChangerPreset.NONE) {
            this.pitch = 0.0f;
        } else if (preset == ZegoVoiceChangerPreset.MEN_TO_CHILD) {
            this.pitch = 8.0f;
        } else if (preset == ZegoVoiceChangerPreset.MEN_TO_WOMEN) {
            this.pitch = 4.0f;
        } else if (preset == ZegoVoiceChangerPreset.WOMEN_TO_CHILD) {
            this.pitch = 6.0f;
        } else if (preset == ZegoVoiceChangerPreset.WOMEN_TO_MEN) {
            this.pitch = -3.0f;
        } else if (preset == null) {
            this.pitch = 0.0f;
        }
    }

    public ZegoVoiceChangerParam(){
        this(ZegoVoiceChangerPreset.NONE);
    }

}
