package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

/**
 * Object for video frame fieldeter
 *
 * Including video frame format, width and height, etc.
 */
public class ZegoVideoFrameParam {

    /** Video frame format */
    public ZegoVideoFrameFormat format;

    /** Number of bytes per line (for example: RGBA only needs to consider strides [0], I420 needs to consider strides [0,1,2]) */
    final public int[] strides = new int[4];

    /** Video frame width */
    public int width;

    /** Video frame height */
    public int height;

    /** Video frame rotation */
    public int rotation;

}
