package im.zego.zegoexpress;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import im.zego.zegoexpress.internal.*;
import android.app.Application;
import android.graphics.*;

/**
 * Zego MediaPlayer
 *
 * Yon can use ZegoMediaPlayer to play media resource files on the local or remote server, and can mix the sound of the media resource files that are played into the publish stream to achieve the effect of background music.
 */
public abstract class ZegoMediaPlayer {

    /**
     * Create a media player instance object
     *
     * Currently, a maximum of 4 instances can be created, after which it will return null.
     *
     * @deprecated This interface is deprecated, please use the [createMediaPlayer] method in ZegoExpressEngine instead.
     * @return Media player instance, null will be returned when the maximum number is exceeded.
     */
    @Deprecated
    public static ZegoMediaPlayer createMediaPlayer(){
        return ZegoMediaPlayerInternalImpl.createMediaPlayer();
    }

    /**
     * Destroy a media player instance object
     *
     * @deprecated This interface is deprecated, please use the [destroyMediaPlayer] method in ZegoExpressEngine instead.
     */
    @Deprecated
    public void destroyMediaPlayer(){
        ZegoMediaPlayerInternalImpl.destroyMediaPlayer(this);
    }

    /**
     * Set event callback handler for media player
     *
     * You can change the player UI widget according to the related event callback of the media player
     *
     * @param handler Media player event callback object
     */
    public abstract void setEventHandler(IZegoMediaPlayerEventHandler handler);

    /**
     * Set audio callback handler
     *
     * You can set this callback to throw the audio data of the media resource file played by the media player
     *
     * @param handler Audio event callback object for media player
     */
    public abstract void setAudioHandler(IZegoMediaPlayerAudioHandler handler);

    /**
     * Load media resource
     *
     * Yon can pass the absolute path of the local resource or the URL of the network resource
     *
     * @param path the absolute path of the local resource or the URL of the network resource
     * @param callback Notification of resource loading results
     */
    public abstract void loadResource(String path, IZegoMediaPlayerLoadResourceCallback callback);

    /**
     * Start playing
     *
     * You need to load resources before playing
     */
    public abstract void start();

    /**
     * Stop playing
     */
    public abstract void stop();

    /**
     * Pause playing
     */
    public abstract void pause();

    /**
     * resume playing
     */
    public abstract void resume();

    /**
     * Set the specified playback progress
     *
     * Unit is millisecond
     *
     * @param millisecond Point in time of specified playback progress
     * @param callback the result notification of set the specified playback progress
     */
    public abstract void seekTo(long millisecond, IZegoMediaPlayerSeekToCallback callback);

    /**
     * Whether to repeat playback
     *
     * @param enable repeat playback flag. The default is false.
     */
    public abstract void enableRepeat(boolean enable);

    /**
     * Whether to mix the player's sound into the stream being published
     *
     * @param enable Aux audio flag. The default is false.
     */
    public abstract void enableAux(boolean enable);

    /**
     * Whether to play locally silently
     *
     * If [enableAux] switch is turned on, there is still sound in the publishing stream. The default is false.
     *
     * @param mute Mute local audio flag, The default is false.
     */
    public abstract void muteLocal(boolean mute);

    /**
     * Set player volume
     *
     * @param volume The range is 0 ~ 100. The default is 50.
     */
    public abstract void setVolume(int volume);

    /**
     * Set playback progress callback interval
     *
     * This interface can control the callback frequency of [onMediaPlayerPlayingProgress]. When the callback interval is set to 0, the callback is stopped. The default callback interval is 1s
     * This callback are not returned exactly at the set callback interval, but rather at the frequency at which the audio or video frames are processed to determine whether the callback is needed to call
     *
     * @param millisecond Interval of playback progress callback in milliseconds
     */
    public abstract void setProgressInterval(long millisecond);

    /**
     * Get the current volume
     *
     * The range is 0 ~ 100. The default is 50
     */
    public abstract int getVolume();

    /**
     * Get the total progress of your media resources
     *
     * You should load resource before invoking this API, otherwise the return value is 0
     *
     * @return Unit is millisecond
     */
    public abstract long getTotalDuration();

    /**
     * Get current playing progress
     *
     * You should load resource before invoking this API, otherwise the return value is 0
     */
    public abstract long getCurrentProgress();

    /**
     * Get the current playback status
     */
    public abstract ZegoMediaPlayerState getCurrentState();

    /**
     * Get media player index
     */
    public abstract int getIndex();

}
