/*
 * Decompiled with CFR 0.152.
 */
package id.zelory.compressor;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import id.zelory.compressor.UtilKt$WhenMappings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\rH\u0000\u001a\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007\u001a\u0016\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0010\u001a\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r\u001a*\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00102\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0007\u001a*\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\r2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0007\u001a\n\u0010\u001b\u001a\u00020\u0016*\u00020\r\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0016\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"separator", "", "kotlin.jvm.PlatformType", "cachePath", "context", "Landroid/content/Context;", "calculateInSampleSize", "", "options", "Landroid/graphics/BitmapFactory$Options;", "reqWidth", "reqHeight", "copyToCache", "Ljava/io/File;", "imageFile", "decodeSampledBitmapFromFile", "Landroid/graphics/Bitmap;", "determineImageRotation", "bitmap", "loadBitmap", "overWrite", "format", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "saveBitmap", "", "destination", "compressFormat", "extension", "compressor_release"})
public final class UtilKt {
    private static final String separator = File.separator;

    private static final String cachePath(Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        File file = context.getCacheDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.cacheDir");
        return stringBuilder.append(file.getPath()).append(separator).append("compressor").append(separator).toString();
    }

    @NotNull
    public static final Bitmap.CompressFormat compressFormat(@NotNull File $this$compressFormat) {
        Bitmap.CompressFormat compressFormat;
        Intrinsics.checkParameterIsNotNull((Object)$this$compressFormat, (String)"$this$compressFormat");
        String string = FilesKt.getExtension((File)$this$compressFormat);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        switch (string3) {
            case "png": {
                compressFormat = Bitmap.CompressFormat.PNG;
                break;
            }
            case "webp": {
                compressFormat = Bitmap.CompressFormat.WEBP;
                break;
            }
            default: {
                compressFormat = Bitmap.CompressFormat.JPEG;
            }
        }
        return compressFormat;
    }

    @NotNull
    public static final String extension(@NotNull Bitmap.CompressFormat $this$extension) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$extension, (String)"$this$extension");
        switch (UtilKt$WhenMappings.$EnumSwitchMapping$0[$this$extension.ordinal()]) {
            case 1: {
                string = "png";
                break;
            }
            case 2: {
                string = "webp";
                break;
            }
            default: {
                string = "jpg";
            }
        }
        return string;
    }

    @NotNull
    public static final Bitmap loadBitmap(@NotNull File imageFile) {
        Intrinsics.checkParameterIsNotNull((Object)imageFile, (String)"imageFile");
        Bitmap bitmap = BitmapFactory.decodeFile((String)imageFile.getAbsolutePath());
        boolean bl = false;
        boolean bl2 = false;
        Bitmap $this$run = bitmap;
        boolean bl3 = false;
        Bitmap bitmap2 = $this$run;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"this");
        return UtilKt.determineImageRotation(imageFile, bitmap2);
    }

    @NotNull
    public static final Bitmap decodeSampledBitmapFromFile(@NotNull File imageFile, int reqWidth, int reqHeight) {
        Intrinsics.checkParameterIsNotNull((Object)imageFile, (String)"imageFile");
        BitmapFactory.Options options = new BitmapFactory.Options();
        boolean bl = false;
        boolean bl2 = false;
        BitmapFactory.Options $this$run = options;
        boolean bl3 = false;
        $this$run.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imageFile.getAbsolutePath(), (BitmapFactory.Options)$this$run);
        $this$run.inSampleSize = UtilKt.calculateInSampleSize($this$run, reqWidth, reqHeight);
        $this$run.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)imageFile.getAbsolutePath(), (BitmapFactory.Options)$this$run);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapFactory.decodeFile\u2026eFile.absolutePath, this)");
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"BitmapFactory.Options().\u2026absolutePath, this)\n    }");
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    public static final int calculateInSampleSize(@NotNull BitmapFactory.Options options, int reqWidth, int reqHeight) {
        void height;
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        BitmapFactory.Options options2 = options;
        boolean bl = false;
        boolean bl2 = false;
        BitmapFactory.Options $this$run = options2;
        boolean bl3 = false;
        Pair pair = TuplesKt.to((Object)$this$run.outHeight, (Object)$this$run.outWidth);
        int n = ((Number)pair.component1()).intValue();
        int width = ((Number)pair.component2()).intValue();
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            void halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    @NotNull
    public static final Bitmap determineImageRotation(@NotNull File imageFile, @NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)imageFile, (String)"imageFile");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        ExifInterface exif = new ExifInterface(imageFile.getAbsolutePath());
        int orientation = exif.getAttributeInt("Orientation", 0);
        Matrix matrix = new Matrix();
        switch (orientation) {
            case 6: {
                matrix.postRotate(90.0f);
                break;
            }
            case 3: {
                matrix.postRotate(180.0f);
                break;
            }
            case 8: {
                matrix.postRotate(270.0f);
            }
        }
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(bitm\u2026map.height, matrix, true)");
        return bitmap2;
    }

    @NotNull
    public static final File copyToCache(@NotNull Context context, @NotNull File imageFile) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)imageFile, (String)"imageFile");
        return FilesKt.copyTo$default((File)imageFile, (File)new File(UtilKt.cachePath(context) + imageFile.getName()), (boolean)true, (int)0, (int)4, null);
    }

    @NotNull
    public static final File overWrite(@NotNull File imageFile, @NotNull Bitmap bitmap, @NotNull Bitmap.CompressFormat format, int quality) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)imageFile, (String)"imageFile");
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        if (format == UtilKt.compressFormat(imageFile)) {
            file = imageFile;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string = imageFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"imageFile.absolutePath");
            file = new File(stringBuilder.append(StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null)).append('.').append(UtilKt.extension(format)).toString());
        }
        File result = file;
        imageFile.delete();
        UtilKt.saveBitmap(bitmap, result, format, quality);
        return result;
    }

    public static /* synthetic */ File overWrite$default(File file, Bitmap bitmap, Bitmap.CompressFormat compressFormat, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            compressFormat = UtilKt.compressFormat(file);
        }
        if ((n2 & 8) != 0) {
            n = 100;
        }
        return UtilKt.overWrite(file, bitmap, compressFormat, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveBitmap(@NotNull Bitmap bitmap, @NotNull File destination, @NotNull Bitmap.CompressFormat format, int quality) {
        FileOutputStream $this$run;
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull((Object)format, (String)"format");
        File file = destination.getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(destination.getAbsolutePath());
            bitmap.compress(format, quality, (OutputStream)fileOutputStream);
            FileOutputStream fileOutputStream2 = fileOutputStream;
            boolean bl = false;
            boolean bl2 = false;
            $this$run = fileOutputStream2;
            boolean bl3 = false;
        }
        catch (Throwable throwable) {
            FileOutputStream fileOutputStream3 = fileOutputStream;
            if (fileOutputStream3 != null) {
                FileOutputStream fileOutputStream4 = fileOutputStream3;
                boolean bl = false;
                boolean bl4 = false;
                FileOutputStream $this$run2 = fileOutputStream4;
                boolean bl5 = false;
                $this$run2.flush();
                $this$run2.close();
            }
            throw throwable;
        }
        $this$run.flush();
        $this$run.close();
    }

    public static /* synthetic */ void saveBitmap$default(Bitmap bitmap, File file, Bitmap.CompressFormat compressFormat, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            compressFormat = UtilKt.compressFormat(file);
        }
        if ((n2 & 8) != 0) {
            n = 100;
        }
        UtilKt.saveBitmap(bitmap, file, compressFormat, n);
    }
}

