/*
 * Decompiled with CFR 0.152.
 */
package id.zelory.compressor;

import android.content.Context;
import android.graphics.Bitmap;
import id.zelory.compressor.ImageUtil;
import io.reactivex.Flowable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;

public class Compressor {
    private int maxWidth = 612;
    private int maxHeight = 816;
    private Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
    private int quality = 80;
    private String destinationDirectoryPath;

    public Compressor(Context context) {
        this.destinationDirectoryPath = context.getCacheDir().getPath() + File.separator + "images";
    }

    public Compressor setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public Compressor setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public Compressor setCompressFormat(Bitmap.CompressFormat compressFormat) {
        this.compressFormat = compressFormat;
        return this;
    }

    public Compressor setQuality(int quality) {
        this.quality = quality;
        return this;
    }

    public Compressor setDestinationDirectoryPath(String destinationDirectoryPath) {
        this.destinationDirectoryPath = destinationDirectoryPath;
        return this;
    }

    public File compressToFile(File imageFile) throws IOException {
        return this.compressToFile(imageFile, imageFile.getName());
    }

    public File compressToFile(File imageFile, String compressedFileName) throws IOException {
        return ImageUtil.compressImage(imageFile, this.maxWidth, this.maxHeight, this.compressFormat, this.quality, this.destinationDirectoryPath + File.separator + compressedFileName);
    }

    public Bitmap compressToBitmap(File imageFile) throws IOException {
        return ImageUtil.decodeSampledBitmapFromFile(imageFile, this.maxWidth, this.maxHeight);
    }

    public Flowable<File> compressToFileAsFlowable(File imageFile) {
        return this.compressToFileAsFlowable(imageFile, imageFile.getName());
    }

    public Flowable<File> compressToFileAsFlowable(final File imageFile, final String compressedFileName) {
        return Flowable.defer((Callable)new Callable<Flowable<File>>(){

            @Override
            public Flowable<File> call() {
                try {
                    return Flowable.just((Object)Compressor.this.compressToFile(imageFile, compressedFileName));
                }
                catch (IOException e) {
                    return Flowable.error((Throwable)e);
                }
            }
        });
    }

    public Flowable<Bitmap> compressToBitmapAsFlowable(final File imageFile) {
        return Flowable.defer((Callable)new Callable<Flowable<Bitmap>>(){

            @Override
            public Flowable<Bitmap> call() {
                try {
                    return Flowable.just((Object)Compressor.this.compressToBitmap(imageFile));
                }
                catch (IOException e) {
                    return Flowable.error((Throwable)e);
                }
            }
        });
    }
}

