/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

public class ThreadAssocStore {
    private static transient ThreadAssocStore instance = new ThreadAssocStore();
    private static final Logger log = Logger.getLogger(ThreadAssocStore.class.toString());
    private final HashMap<Thread, HashMap<String, Object>> map = new HashMap();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private transient Long lastCleanupTime;
    private static final Long cleanupTimeout = 60000L;

    public static final ThreadAssocStore getInstance() {
        if (instance == null) {
            instance = new ThreadAssocStore();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Thread t, String key, Object value) {
        this.cleanup();
        this.lock.writeLock().lock();
        try {
            log.finest("SET value for: " + key + " on " + t.toString());
            HashMap<String, Object> subMap = this.map.get(t);
            if (subMap == null) {
                subMap = new HashMap();
                this.map.put(t, subMap);
            }
            if (value == null) {
                subMap.remove(key);
            } else {
                subMap.put(key, value);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setValue(String key, Object value) {
        this.setValue(Thread.currentThread(), key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(Thread t, String key) {
        this.lock.readLock().lock();
        try {
            log.finest("GET value for: " + key + " on " + t.toString());
            HashMap<String, Object> subMap = this.map.get(t);
            if (subMap == null) {
                Object var4_4 = null;
                return var4_4;
            }
            Object object = subMap.get(key);
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Object getValue(String key) {
        return this.getValue(Thread.currentThread(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.lock.writeLock().lock();
        try {
            if (this.lastCleanupTime == null) {
                this.lastCleanupTime = System.currentTimeMillis();
                return;
            }
            long delta = System.currentTimeMillis() - this.lastCleanupTime;
            if (delta < cleanupTimeout) {
                return;
            }
            this.lastCleanupTime = System.currentTimeMillis();
            Set<Thread> keys = this.map.keySet();
            Iterator<Thread> iter = keys.iterator();
            while (iter.hasNext()) {
                Thread t = iter.next();
                if (t.isAlive()) continue;
                iter.remove();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear(Thread t) {
        this.lock.writeLock().lock();
        try {
            this.map.remove(t);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear(String key) {
        this.clear(Thread.currentThread(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Thread t, String key) {
        this.lock.writeLock().lock();
        try {
            HashMap<String, Object> subMap = this.map.get(t);
            if (subMap == null) {
                return;
            }
            subMap.remove(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

