/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util;

import com.google.common.io.Files;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.search.Search;
import hudson.search.SearchIndex;
import hudson.security.ACL;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.apache.commons.io.FileUtils;

public class MockItemGroup<T extends Job<?, ?>>
implements ItemGroup<T>,
TopLevelItem {
    private final File tmpDir = Files.createTempDir();
    private final String uuid = UUID.randomUUID().toString();
    LinkedList<T> items = new LinkedList();

    public void finalize() {
        this.clean();
    }

    public void clean() {
        if (this.tmpDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.tmpDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public File getRootDir() {
        return this.tmpDir;
    }

    public void save() throws IOException {
    }

    public String getDisplayName() {
        return this.uuid;
    }

    public String getFullName() {
        return this.uuid;
    }

    public String getFullDisplayName() {
        return this.uuid;
    }

    public Collection<T> getItems() {
        return this.items;
    }

    public String getUrl() {
        return this.uuid;
    }

    public String getUrlChildPrefix() {
        return this.uuid;
    }

    public void addItem(T item) {
        this.items.add(item);
    }

    public T getItem(String name) throws AccessDeniedException {
        for (Job item : this.items) {
            if (!name.equals(item.getName())) continue;
            return (T)item;
        }
        return null;
    }

    public File getRootDirFor(T child) {
        return new File(this.tmpDir, child.getFullName());
    }

    public void onRenamed(T item, String oldName, String newName) throws IOException {
    }

    public void onDeleted(T item) throws IOException {
    }

    public void delete() throws IOException, InterruptedException {
    }

    public String getAbsoluteUrl() {
        return null;
    }

    public Collection<? extends Job> getAllJobs() {
        return null;
    }

    public String getName() {
        return this.uuid;
    }

    public ItemGroup<? extends Item> getParent() {
        return Jenkins.getInstance().getItemGroup();
    }

    public String getRelativeNameFrom(ItemGroup arg0) {
        return this.uuid;
    }

    public String getRelativeNameFrom(Item arg0) {
        return this.uuid;
    }

    public String getShortUrl() {
        return null;
    }

    public void onCopiedFrom(Item arg0) {
    }

    public void onCreatedFromScratch() {
    }

    public void onLoad(ItemGroup<? extends Item> arg0, String arg1) throws IOException {
    }

    public Search getSearch() {
        return null;
    }

    public SearchIndex getSearchIndex() {
        return null;
    }

    public String getSearchName() {
        return this.uuid;
    }

    public String getSearchUrl() {
        return null;
    }

    public void checkPermission(Permission arg0) throws AccessDeniedException {
    }

    public ACL getACL() {
        return null;
    }

    public boolean hasPermission(Permission arg0) {
        return true;
    }

    public TopLevelItemDescriptor getDescriptor() {
        return null;
    }
}

