/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.references;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.parameters.InheritableStringParameterDefinition;
import hudson.plugins.project_inheritance.projects.parameters.InheritanceParametersDefinitionProperty;
import hudson.plugins.project_inheritance.projects.references.AbstractProjectReference;
import hudson.plugins.project_inheritance.projects.references.SimpleProjectReference;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class SimpleParameterizedProjectReference
extends SimpleProjectReference {
    protected List<ParameterDefinition> parameters;
    protected String variance = null;

    @DataBoundConstructor
    public SimpleParameterizedProjectReference(String targetJob, List<ParameterDefinition> parameters) {
        super(targetJob);
        InheritanceProject project = this.getProject();
        if (project != null && parameters != null) {
            for (ParameterDefinition pd : parameters) {
                if (!(pd instanceof InheritableStringParameterDefinition)) continue;
                InheritableStringParameterDefinition ispd = (InheritableStringParameterDefinition)pd;
                ispd.setRootProperty(project.getProperty(InheritanceParametersDefinitionProperty.class));
            }
        }
        this.parameters = parameters == null ? new LinkedList<ParameterDefinition>() : parameters;
    }

    public List<ParameterDefinition> getParameters() {
        if (this.parameters == null) {
            this.parameters = new LinkedList<ParameterDefinition>();
        }
        return this.parameters;
    }

    @Extension
    public static class SimpleParameterizedReferenceDescriptor
    extends AbstractProjectReference.ProjectReferenceDescriptor {
        public String getDisplayName() {
            return "Simple Parameterized Project Reference";
        }

        public AbstractProjectReference newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String name = formData.getString("name");
            Object jParams = formData.get("parameters");
            List params = ParameterDefinition.ParameterDescriptor.newInstancesFromHeteroList((StaplerRequest)req, (Object)jParams, (Collection)ParameterDefinition.all());
            return new SimpleParameterizedProjectReference(name, params);
        }
    }
}

