/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.parameters;

import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.parameters.InheritableStringParameterValue;
import hudson.plugins.project_inheritance.projects.parameters.InheritanceParametersDefinitionProperty;
import hudson.plugins.project_inheritance.projects.parameters.Messages;
import hudson.plugins.project_inheritance.projects.references.AbstractProjectReference;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class InheritableStringParameterDefinition
extends StringParameterDefinition {
    private static final long serialVersionUID = 5458085487475338803L;
    private static final Logger log = Logger.getLogger(InheritableStringParameterDefinition.class.toString());
    private final IModes inheritanceMode;
    private final boolean mustHaveDefaultValue;
    private final boolean mustBeAssigned;
    private final boolean isHidden;
    private WhitespaceMode whitespaceMode;
    @Deprecated
    private boolean autoAddSpaces;
    private transient InheritanceParametersDefinitionProperty rootProperty = null;
    public transient String variance = null;

    public InheritableStringParameterDefinition(String name, String defaultValue) {
        this(name, defaultValue, null, IModes.OVERWRITABLE, false, false, WhitespaceMode.ADD_IF_EXTENSION, false);
    }

    public InheritableStringParameterDefinition(String name, String defaultValue, IModes iMode, boolean mustHaveDefaultValue, boolean mustBeAssigned, WhitespaceMode whitespaceMode, boolean isHidden) {
        this(name, defaultValue, null, iMode, mustHaveDefaultValue, mustBeAssigned, whitespaceMode, isHidden);
    }

    public InheritableStringParameterDefinition(String name, String defaultValue, String description, IModes inheritanceMode, boolean mustHaveDefaultValue, boolean mustBeAssigned, WhitespaceMode whitespaceMode, boolean isHidden) {
        super(StringUtils.trim((String)name), defaultValue, description);
        this.mustHaveDefaultValue = mustHaveDefaultValue;
        this.mustBeAssigned = mustBeAssigned;
        this.isHidden = isHidden;
        this.whitespaceMode = whitespaceMode == null ? WhitespaceMode.KEEP : whitespaceMode;
        this.inheritanceMode = inheritanceMode == null ? IModes.OVERWRITABLE : inheritanceMode;
    }

    @DataBoundConstructor
    public InheritableStringParameterDefinition(String name, String defaultValue, String description, String inheritanceMode, boolean mustHaveDefaultValue, boolean mustBeAssigned, String whitespaceMode, boolean isHidden) {
        this(StringUtils.trim((String)name), defaultValue, description, StringUtils.isBlank((String)inheritanceMode) ? IModes.OVERWRITABLE : IModes.valueOf(inheritanceMode), mustHaveDefaultValue, mustBeAssigned, StringUtils.isBlank((String)whitespaceMode) ? WhitespaceMode.KEEP : WhitespaceMode.valueOf(whitespaceMode), isHidden);
    }

    public InheritableStringParameterDefinition(InheritableStringParameterDefinition other) {
        this(other.getName(), other.getDefaultValue(), other.getDescription(), other.getInheritanceModeAsVar(), other.getMustHaveDefaultValue(), other.getMustBeAssigned(), other.getWhitespaceModeAsVar(), other.getIsHidden());
        this.rootProperty = other.rootProperty;
        this.variance = other.variance;
    }

    public Object readResolve() {
        if (this.whitespaceMode == null) {
            this.whitespaceMode = this.autoAddSpaces ? WhitespaceMode.ADD_IF_EXTENSION : WhitespaceMode.KEEP;
        }
        return this;
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (!(defaultValue instanceof StringParameterValue)) {
            return super.copyWithDefaultValue(defaultValue);
        }
        StringParameterValue spv = (StringParameterValue)defaultValue;
        String value = spv.value;
        InheritableStringParameterDefinition ispd = new InheritableStringParameterDefinition(this.getName(), value, this.getDescription(), this.getInheritanceModeAsVar(), this.getMustHaveDefaultValue(), this.getMustBeAssigned(), this.getWhitespaceModeAsVar(), this.getIsHidden());
        ispd.variance = this.variance;
        ispd.setRootProperty(this.rootProperty);
        return ispd;
    }

    public void setRootProperty(InheritanceParametersDefinitionProperty root) {
        this.rootProperty = root;
    }

    public InheritanceParametersDefinitionProperty getRootProperty() {
        return this.rootProperty;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[");
        b.append(this.getName());
        String loc = this.getLocationString();
        if (loc != null) {
            b.append("; from: ");
            b.append(loc);
        }
        b.append("]");
        return b.toString();
    }

    public String getLocationString() {
        StringBuilder b = new StringBuilder();
        if (this.rootProperty != null) {
            List<InheritanceParametersDefinitionProperty.ScopeEntry> fullScope = this.rootProperty.getScopedParameterDefinition(this.getName());
            String owner = null;
            for (InheritanceParametersDefinitionProperty.ScopeEntry scope : fullScope) {
                if (scope.param != this) continue;
                owner = scope.owner;
                break;
            }
            if (owner != null) {
                b.append(owner);
            } else if (this.rootProperty.getOwner() != null) {
                b.append("?->");
                b.append(this.rootProperty.getOwner().getFullName());
            } else {
                b.append("!->BROKEN");
            }
        } else {
            b.append("!->UNKNOWN");
        }
        if (this.variance != null) {
            b.append("; variance: '");
            b.append(this.variance);
            b.append("'");
        }
        return b.toString();
    }

    public String getDefinitionLocationDescription() {
        StringBuilder b = new StringBuilder();
        b.append("[from: ");
        String loc = this.getLocationString();
        if (loc != null) {
            b.append(loc);
        }
        b.append("] ");
        b.append(this.getDescription());
        return b.toString();
    }

    public boolean getMustHaveDefaultValue() {
        return this.mustHaveDefaultValue;
    }

    public boolean getMustBeAssigned() {
        return this.mustBeAssigned;
    }

    public String getInheritanceMode() {
        return this.getInheritanceModeAsVar().name();
    }

    public IModes getInheritanceModeAsVar() {
        if (this.inheritanceMode == null) {
            return IModes.OVERWRITABLE;
        }
        return this.inheritanceMode;
    }

    public boolean getIsHidden() {
        return this.isHidden;
    }

    public String getWhitespaceMode() {
        WhitespaceMode m = this.getWhitespaceModeAsVar();
        return m.name();
    }

    public WhitespaceMode getWhitespaceModeAsVar() {
        if (this.whitespaceMode == null) {
            return WhitespaceMode.KEEP;
        }
        return this.whitespaceMode;
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        StringParameterValue value = (StringParameterValue)req.bindJSON(StringParameterValue.class, jo);
        if (value == null) {
            return null;
        }
        try {
            StringParameterValue dValue = this.produceDerivedValue(value.value);
            if (dValue == null) {
                return value;
            }
            return dValue;
        }
        catch (IllegalArgumentException ex) {
            log.warning("Could not create inheritable string parameter: " + ex.toString());
            return value;
        }
    }

    public ParameterValue createValue(String value) {
        try {
            StringParameterValue spv = this.produceDerivedValue(value);
            if (spv == null) {
                return super.createValue(value);
            }
            return spv;
        }
        catch (IllegalArgumentException ex) {
            log.warning("Could not create inheritable string parameter: " + ex.toString());
            return super.createValue(value);
        }
    }

    private StringParameterValue produceDerivedValue(String userEnteredValue) throws IllegalArgumentException {
        if (this.rootProperty == null) {
            log.warning("No root property defined for the param: " + this.getName());
            return null;
        }
        List<InheritanceParametersDefinitionProperty.ScopeEntry> fullScope = this.rootProperty.getScopedParameterDefinition(this.getName());
        if (fullScope == null) {
            return new InheritableStringParameterValue(this.getName(), userEnteredValue, this.getDescription());
        }
        String value = "";
        IModes currMode = IModes.OVERWRITABLE;
        boolean mustHaveValueSet = false;
        Iterator<InheritanceParametersDefinitionProperty.ScopeEntry> iter = fullScope.iterator();
        block5: while (iter.hasNext()) {
            String ispdVal;
            InheritanceParametersDefinitionProperty.ScopeEntry scope = iter.next();
            if (!(scope.param instanceof InheritableStringParameterDefinition)) continue;
            InheritableStringParameterDefinition ispd = (InheritableStringParameterDefinition)scope.param.copyWithDefaultValue(scope.param.getDefaultParameterValue());
            ispd.setRootProperty(this.rootProperty);
            String string = ispdVal = !iter.hasNext() ? userEnteredValue : ispd.getDefaultValue();
            if (ispdVal == null) continue;
            mustHaveValueSet |= ispd.getMustBeAssigned();
            WhitespaceMode wsMode = ispd.getWhitespaceModeAsVar();
            if (wsMode == WhitespaceMode.TRIM) {
                ispdVal = StringUtils.trim((String)ispdVal);
            }
            switch (currMode) {
                case OVERWRITABLE: {
                    value = ispdVal;
                    break;
                }
                case EXTENSIBLE: {
                    if (wsMode == WhitespaceMode.ADD_IF_EXTENSION) {
                        value = value + " ";
                    }
                    value = value + ispdVal;
                    break;
                }
                case FIXED: {
                    String msg = "Not allowed to alter fixed parameter " + scope.param.getName();
                    log.warning(msg);
                    throw new IllegalArgumentException(msg);
                }
                default: {
                    log.severe(String.format("Detected unknown inheritance mode: %s", currMode.toString()));
                    continue block5;
                }
            }
            currMode = ispd.getInheritanceModeAsVar();
        }
        InheritableStringParameterValue ispv = new InheritableStringParameterValue(this.getName(), value, this.getDescription());
        ispv.setMustHaveValueSet(mustHaveValueSet);
        return ispv;
    }

    public String getDerivedValue(String userEnteredValue, boolean noThrow) throws IllegalArgumentException {
        try {
            String val = this.stripInheritedPrefixFromValue(userEnteredValue);
            StringParameterValue spv = this.produceDerivedValue(val);
            if (spv == null) {
                return null;
            }
            return spv.value;
        }
        catch (IllegalArgumentException ex) {
            if (noThrow) {
                return null;
            }
            throw ex;
        }
    }

    public String getLocalValue(String userEnteredValue) {
        return this.stripInheritedPrefixFromValue(userEnteredValue);
    }

    public String getDefaultValue() {
        return super.getDefaultValue();
    }

    public String stripInheritedPrefixFromValue(String value) {
        if (value == null || value.isEmpty() || this.rootProperty == null) {
            return value;
        }
        List<InheritanceParametersDefinitionProperty.ScopeEntry> fullScope = this.rootProperty.getScopedParameterDefinition(this.getName());
        if (fullScope == null || fullScope.isEmpty()) {
            return value;
        }
        String newVal = value;
        Iterator<InheritanceParametersDefinitionProperty.ScopeEntry> sIter = fullScope.iterator();
        block3: while (sIter.hasNext()) {
            InheritanceParametersDefinitionProperty.ScopeEntry scope = sIter.next();
            if (scope.param == null || !(scope.param instanceof InheritableStringParameterDefinition)) continue;
            if (scope.param == this) break;
            InheritableStringParameterDefinition ispd = (InheritableStringParameterDefinition)scope.param;
            if (!sIter.hasNext()) break;
            switch (ispd.getInheritanceModeAsVar()) {
                case EXTENSIBLE: {
                    break;
                }
                default: {
                    newVal = value;
                    continue block3;
                }
            }
            String defVal = ispd.getDefaultValue().trim();
            if (!newVal.startsWith(defVal)) continue;
            newVal = newVal.substring(defVal.length()).trim();
        }
        return newVal;
    }

    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
    }

    public StringParameterValue getDefaultParameterValue() {
        return super.getDefaultParameterValue();
    }

    @Extension
    public static class DescriptorImpl
    extends StringParameterDefinition.DescriptorImpl {
        public String getDisplayName() {
            return Messages.InheritableStringParameterDefinition_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/project-inheritance/help/parameter/inheritableString.html";
        }

        public FormValidation doCheckName(@QueryParameter String name, @AncestorInPath InheritanceProject project) {
            if (project == null) {
                return FormValidation.ok();
            }
            FormValidation fv = FormValidation.ok();
            Set<InheritanceProject> references = this.getReferencedProjects(project);
            for (InheritanceProject proj : references) {
                InheritanceParametersDefinitionProperty ipdp;
                List<InheritanceParametersDefinitionProperty.ScopeEntry> scope;
                ParametersDefinitionProperty pdp = proj.getProperty(ParametersDefinitionProperty.class, InheritanceProject.IMode.INHERIT_FORCED);
                if (!(pdp instanceof InheritanceParametersDefinitionProperty) || (scope = (ipdp = (InheritanceParametersDefinitionProperty)pdp).getScopedParameterDefinition(name)) == null) continue;
                for (InheritanceParametersDefinitionProperty.ScopeEntry entry : scope) {
                    String msg;
                    if (entry.param == null || !(entry.param instanceof InheritableStringParameterDefinition) || !entry.param.getName().equals(name) || entry.owner.equals(project.getFullName())) continue;
                    InheritableStringParameterDefinition ispd = (InheritableStringParameterDefinition)entry.param;
                    IModes mode = ispd.getInheritanceModeAsVar();
                    if (mode == IModes.FIXED) {
                        if (proj != project) {
                            msg = String.format("Be careful! This variable is marked as fixed in the compatible job: %s", proj.getFullName());
                            fv = FormValidation.warning((String)msg);
                        } else {
                            msg = String.format("You may not override a parameter marked as fixed in the parent: %s.", entry.owner);
                            fv = FormValidation.error((String)msg);
                        }
                        return fv;
                    }
                    msg = String.format("FYI: You are redefining a parameter that is marked as '%s'%s%s and was defined in the %s: %s.", mode.toString(), ispd.getMustBeAssigned() ? ", must be assigned before run" : "", ispd.getMustHaveDefaultValue() ? ",  must have a default set" : "", proj == project ? "parent" : "compatible job", entry.owner);
                    fv = FormValidation.ok((String)msg);
                }
            }
            return fv;
        }

        public FormValidation doCheckDefaultValue(@QueryParameter String name) {
            return FormValidation.ok();
        }

        public ListBoxModel doFillInheritanceModeItems() {
            ListBoxModel m = new ListBoxModel();
            for (IModes im : IModes.values()) {
                m.add(im.toString(), im.name());
            }
            return m;
        }

        public ListBoxModel doFillWhitespaceModeItems() {
            ListBoxModel m = new ListBoxModel();
            for (WhitespaceMode mode : WhitespaceMode.values()) {
                m.add(mode.toString(), mode.name());
            }
            return m;
        }

        protected Set<InheritanceProject> getReferencedProjects(InheritanceProject root) {
            if (root == null) {
                return Collections.emptySet();
            }
            HashSet<InheritanceProject> refs = new HashSet<InheritanceProject>();
            refs.add(root);
            for (AbstractProjectReference apr : root.getCompatibleProjects()) {
                InheritanceProject mate = apr.getProject();
                if (mate == null) continue;
                refs.add(mate);
            }
            return refs;
        }
    }

    public static enum WhitespaceMode {
        TRIM,
        KEEP,
        ADD_IF_EXTENSION;


        public String toString() {
            switch (this) {
                case KEEP: {
                    return Messages.WhitespaceMode_KEEP();
                }
                case TRIM: {
                    return Messages.WhitespaceMode_TRIM();
                }
                case ADD_IF_EXTENSION: {
                    return Messages.WhitespaceMode_ADD();
                }
            }
            return this.name();
        }
    }

    public static enum IModes {
        OVERWRITABLE,
        EXTENSIBLE,
        FIXED;

        private static final String[] names;

        private static String[] getNames() {
            String[] n = new String[IModes.values().length];
            n[IModes.FIXED.ordinal()] = "Fixed";
            n[IModes.EXTENSIBLE.ordinal()] = "Extensible";
            n[IModes.OVERWRITABLE.ordinal()] = "Overwritable";
            return n;
        }

        public static IModes getFromName(String name) {
            for (int i = 0; i < names.length; ++i) {
                if (!name.equals(names[i])) continue;
                return IModes.values()[i];
            }
            return null;
        }

        public String toString() {
            return names[this.ordinal()];
        }

        public boolean isFixed() {
            return this == FIXED;
        }

        static {
            names = IModes.getNames();
        }
    }
}

