/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util.svg.primitives;

import hudson.plugins.project_inheritance.util.svg.primitives.SVGPrimitive;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGLink
implements SVGPrimitive {
    private final URL link;
    private final SVGPrimitive body;

    public SVGLink(URL link, SVGPrimitive body) {
        this.link = link;
        this.body = body;
    }

    public String toString() {
        String str = this.link.toString();
        if (str.length() <= 16) {
            return String.format("lnk[%s]", str);
        }
        return String.format("lnk[...%s]", str.substring(str.length() - 13));
    }

    @Override
    public Element render(Document doc) {
        Element lnk = doc.createElement("a");
        lnk.setAttribute("xlink:href", this.link.toString());
        if (this.body != null) {
            lnk.appendChild(this.body.render(doc));
        }
        return lnk;
    }

    @Override
    public void translate(Point2D.Double offset) {
        if (this.body != null) {
            this.body.translate(offset);
        }
    }

    @Override
    public void moveTo(Point2D.Double pos) {
        if (this.body != null) {
            this.body.moveTo(pos);
        }
    }

    @Override
    public void rescale(double factor, boolean applyToStyles) {
        if (this.body != null) {
            this.body.rescale(factor, applyToStyles);
        }
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.body != null) {
            return this.body.getBounds();
        }
        return null;
    }

    @Override
    public List<Point2D.Double> getAttachmentPoints() {
        if (this.body != null) {
            return this.body.getAttachmentPoints();
        }
        return null;
    }
}

