/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TimedBuffer<O, K> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final long timeout;
    private final HashMap<O, HashMap<K, TimeCapsule>> map = new HashMap();

    public TimedBuffer() {
        this(-1L);
    }

    public TimedBuffer(long timeoutMillis) {
        this.timeout = timeoutMillis;
    }

    public Object get(O obj, K key) {
        Map.Entry<Object, Long> entry = this.getWithTimestamp(obj, key);
        return entry != null ? entry.getKey() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<Object, Long> getWithTimestamp(O obj, K key) {
        this.lock.readLock().lock();
        try {
            HashMap<K, TimeCapsule> tMap = this.map.get(obj);
            if (tMap == null) {
                Map.Entry<Object, Long> entry = null;
                return entry;
            }
            TimeCapsule tc = tMap.get(key);
            if (tc == null) {
                Map.Entry<Object, Long> entry = null;
                return entry;
            }
            if (this.timeout > 0L && tc.agedPast(this.timeout)) {
                Map.Entry<Object, Long> entry = null;
                return entry;
            }
            AbstractMap.SimpleEntry<Object, Long> simpleEntry = new AbstractMap.SimpleEntry<Object, Long>(tc.obj, tc.cTime);
            return simpleEntry;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(O obj, K key, Object value) {
        this.lock.writeLock().lock();
        try {
            HashMap<K, TimeCapsule> tMap = this.map.get(obj);
            if (tMap == null) {
                tMap = new HashMap();
                tMap.put(key, new TimeCapsule(value));
                this.map.put(obj, tMap);
                return;
            }
            tMap.put(key, new TimeCapsule(value));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(O obj, K key) {
        this.lock.writeLock().lock();
        try {
            HashMap<K, TimeCapsule> tMap = this.map.get(obj);
            if (tMap == null) {
                return;
            }
            tMap.remove(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear(O obj) {
        this.lock.writeLock().lock();
        this.map.remove(obj);
        this.lock.writeLock().unlock();
    }

    public void clearAll() {
        this.lock.writeLock().lock();
        this.map.clear();
        this.lock.writeLock().unlock();
    }

    public void clearAll(K key) {
        this.lock.writeLock().lock();
        for (HashMap<K, TimeCapsule> tMap : this.map.values()) {
            if (tMap == null) continue;
            tMap.remove(key);
        }
        this.lock.writeLock().unlock();
    }

    public void cull() {
        if (this.timeout <= 0L) {
            return;
        }
        this.lock.writeLock().lock();
        for (HashMap<K, TimeCapsule> tMap : this.map.values()) {
            if (tMap == null) continue;
            Iterator<TimeCapsule> iter = tMap.values().iterator();
            while (iter.hasNext()) {
                TimeCapsule tc = iter.next();
                if (tc == null || !tc.agedPast(this.timeout)) continue;
                iter.remove();
            }
        }
        this.lock.writeLock().unlock();
    }

    private class TimeCapsule {
        public final Object obj;
        public final long cTime;

        public TimeCapsule(Object obj) {
            this.obj = obj;
            this.cTime = System.currentTimeMillis();
        }

        public boolean agedPast(long timeout) {
            return System.currentTimeMillis() - this.cTime > timeout;
        }
    }
}

