/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.view;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class ReadOnlyConfigurationArchive
implements HttpResponse {
    private final String name;
    private final File file;

    public ReadOnlyConfigurationArchive(String name, File file) {
        this.file = file;
        this.name = StringUtils.isBlank((String)name) ? file.getName() : name;
    }

    private void close() {
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        URLConnection con = this.connect();
        rsp.setHeader("Content-Disposition", "attachment; filename=" + this.name);
        InputStream in = con.getInputStream();
        rsp.serveFile(req, in, con.getLastModified(), con.getContentLengthLong(), this.file.getName());
        in.close();
        this.close();
    }

    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        this.doIndex(req, rsp);
    }

    private URLConnection connect() throws IOException {
        URL res = this.getURL();
        return res.openConnection();
    }

    public URL getURL() throws MalformedURLException {
        URL res = this.file.toURI().toURL();
        return res;
    }
}

