/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.view;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Items;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.plugins.project_inheritance.projects.InheritanceBuild;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.versioning.VersionHandler;
import hudson.plugins.project_inheritance.projects.view.BuildFlowScriptExtension;
import hudson.plugins.project_inheritance.projects.view.ReadOnlyConfigurationArchive;
import hudson.plugins.project_inheritance.projects.view.scripts.MetaScript;
import hudson.plugins.project_inheritance.util.PathMapping;
import hudson.tasks.Builder;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class BuildFlowScriptAction
implements RunAction2,
Describable<BuildFlowScriptAction> {
    private static final Logger log = Logger.getLogger(BuildFlowScriptAction.class.toString());
    private static final Charset UTF8 = Charset.forName("utf8");
    private static final String LABEL_DISPLAY_NAME = "Full Build Flow";
    private transient AbstractBuild<?, ?> build;

    public void onAttached(Run<?, ?> r) {
        this.build = r instanceof AbstractBuild ? (AbstractBuild)r : null;
    }

    public void onLoad(Run<?, ?> r) {
        this.build = r instanceof AbstractBuild ? (AbstractBuild)r : null;
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void registerXStream() {
        XStream2[] xsa;
        for (XStream2 xs : xsa = new XStream2[]{Jenkins.XSTREAM2, Items.XSTREAM2, Build.XSTREAM2}) {
            xs.addCompatibilityAlias("hudson.plugins.project_inheritance.projects.view.InheritanceViewAction", BuildFlowScriptAction.class);
        }
    }

    public AbstractProject<?, ?> getProject() {
        AbstractBuild<?, ?> b = this.getBuild();
        return b != null ? (AbstractProject)b.getParent() : null;
    }

    public InheritanceProject getProject(StaplerRequest request) {
        return InheritanceProject.DESCRIPTOR.getConfiguredProject(request);
    }

    public AbstractBuild<?, ?> getBuild() {
        if (this.build == null) {
            StaplerRequest req = Stapler.getCurrentRequest();
            return this.getBuild(req);
        }
        return this.build;
    }

    public AbstractBuild<?, ?> getBuild(StaplerRequest req) {
        if (req != null) {
            return (AbstractBuild)req.findAncestorObject(AbstractBuild.class);
        }
        return this.build;
    }

    private boolean isApplicableFor(AbstractProject<?, ?> p) {
        return p != null && p.isBuildable() && !p.isDisabled();
    }

    public String getIconFileName() {
        AbstractProject<?, ?> p = this.getProject();
        if (this.isApplicableFor(p)) {
            return "notepad.png";
        }
        return null;
    }

    public String getDisplayName() {
        AbstractProject<?, ?> p = this.getProject();
        if (this.isApplicableFor(p)) {
            return LABEL_DISPLAY_NAME;
        }
        return null;
    }

    public String getUrlName() {
        AbstractProject<?, ?> p = this.getProject();
        if (this.isApplicableFor(p)) {
            return "view";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadOnlyConfigurationArchive doDownload() {
        AbstractProject<?, ?> proj = this.getProject();
        AbstractBuild<?, ?> build = this.getBuild();
        Map<String, Long> versions = null;
        if (build instanceof InheritanceBuild) {
            Map<String, Long> map = versions = build != null ? ((InheritanceBuild)build).getProjectVersions() : null;
        }
        if (versions != null) {
            VersionHandler.initVersions(versions);
        }
        String name = build != null ? String.format("%s_%d", proj.getFullName(), build.getNumber()) : proj.getFullName();
        name = PathMapping.getSafePath(name);
        try {
            File archive = this.generateExecutableCompoundScript(build, this.getBuildersFor(proj), name, BuildFlowScriptAction.getResolvedBuildParameters(this.getBuild()));
            String ext = FilenameUtils.getExtension((String)archive.getName());
            ReadOnlyConfigurationArchive readOnlyConfigurationArchive = new ReadOnlyConfigurationArchive(String.format("%s.%s", name, ext), archive);
            return readOnlyConfigurationArchive;
        }
        catch (IOException ex) {
            log.warning(String.format("Failed to generate script download for %s. Reason: %s", build, ex.getMessage()));
            ReadOnlyConfigurationArchive readOnlyConfigurationArchive = null;
            return readOnlyConfigurationArchive;
        }
        finally {
            VersionHandler.clearVersions();
        }
    }

    protected List<Builder> getBuildersFor(AbstractProject<?, ?> p) {
        if (p instanceof InheritanceProject) {
            InheritanceProject ip = (InheritanceProject)p;
            return ip.getBuildersList(InheritanceProject.IMode.INHERIT_FORCED).toList();
        }
        if (p instanceof Project) {
            return ((Project)p).getBuilders();
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generateExecutableCompoundScript(AbstractBuild<?, ?> build, List<Builder> builders, String archiveName, Map<String, String> params) throws IOException {
        List<MetaScript> scripts;
        params = BuildFlowScriptExtension.filterEnv(params);
        try {
            BuildFlowScriptExtension.initThread();
            scripts = BuildFlowScriptExtension.getScriptsFor(null, build.getProject(), build, builders, params, new AtomicInteger());
        }
        finally {
            BuildFlowScriptExtension.cleanUpThread();
        }
        Map<String, String> env = BuildFlowScriptAction.getResolvedBuildParameters(this.getBuild());
        MetaScript bashCtrl = BuildFlowScriptAction.getBashControlFile(null, null, scripts, env, true);
        MetaScript cmdCtrl = BuildFlowScriptAction.getCmdControlFile(null, null, scripts, env, true);
        for (MetaScript ms : scripts) {
            ms.setCallable(false);
        }
        scripts.add(bashCtrl);
        scripts.add(cmdCtrl);
        File dstFile = File.createTempFile(archiveName + "_", ".tgz");
        if (dstFile.getParentFile() != null) {
            dstFile.getParentFile().mkdirs();
        }
        try {
            this.createTgzArchive(dstFile, scripts);
        }
        catch (IOException ex) {
            log.warning(String.format("Failed to generate script files for %s. Reason: %s", build, ex.getMessage()));
            return null;
        }
        return dstFile;
    }

    public static MetaScript getCmdControlFile(File prefix, String scriptName, List<MetaScript> scripts, Map<String, String> env, boolean setWorkspaceVars) {
        StringBuilder out = new StringBuilder();
        if (StringUtils.isBlank((String)scriptName)) {
            scriptName = "build";
        }
        out.append("@echo off\r\n");
        if (env.size() > 0) {
            for (String key : env.keySet()) {
                out.append(String.format("set %s=%s\r\n", key, env.get(key)));
            }
        }
        out.append("\r\n");
        if (setWorkspaceVars) {
            out.append("set ROOT=%cd%\r\n");
            out.append("set WORKSPACE=%ROOT%\\workspace\r\n");
            out.append("mkdir \"%WORKSPACE%\"\r\n");
            out.append("cd \"%WORKSPACE%\"\r\n");
            out.append("\r\n");
        }
        for (MetaScript script : scripts) {
            if (!script.isCallable() || script.file.getName().endsWith(".sh")) continue;
            String fName = FilenameUtils.separatorsToWindows((String)script.file.getPath());
            out.append(String.format("echo Will run %s now ...\r\n", fName));
            if (StringUtils.isBlank((String)script.shebang)) {
                out.append(String.format("call '%s'\r\n", fName));
            } else {
                out.append(String.format("%s '%%ROOT%%\\%s'\r\n", script.shebang, fName));
            }
            out.append("if errorlevel 1 ( exit 1 )\r\n");
            out.append("\r\n");
        }
        File scriptfile = prefix != null ? new File(prefix, scriptName + ".bat") : new File(scriptName + ".bat");
        return new MetaScript("", out.toString(), scriptfile);
    }

    public static MetaScript getBashControlFile(File prefix, String scriptName, List<MetaScript> scripts, Map<String, String> env, boolean setWorkspaceVars) {
        StringBuilder out = new StringBuilder();
        if (StringUtils.isBlank((String)scriptName)) {
            scriptName = "build";
        }
        out.append("#!/bin/bash\n\n");
        if (env.size() > 0) {
            for (String key : env.keySet()) {
                out.append(String.format("export %s=\"%s\"\n", key, env.get(key)));
            }
        }
        out.append('\n');
        if (setWorkspaceVars) {
            out.append("export ROOT=\"$(pwd)\"\n");
            out.append("export WORKSPACE=\"$ROOT/workspace\"\n");
            out.append("mkdir -p \"$WORKSPACE\"\n");
            out.append("cd \"$WORKSPACE\"\n");
            out.append('\n');
        }
        for (MetaScript script : scripts) {
            if (!script.isCallable() || script.file.getName().endsWith(".bat")) continue;
            String fName = FilenameUtils.separatorsToUnix((String)script.file.getPath());
            out.append(String.format("echo 'Will run %s now ...'\n", fName));
            out.append(String.format("$ROOT/%s\n", fName));
            out.append("if [[ $? -ne 0 ]]; then exit 1; fi\n");
            out.append('\n');
        }
        File scriptfile = prefix != null ? new File(prefix, scriptName + ".sh") : new File(scriptName + ".sh");
        return new MetaScript("/bin/bash", out.toString(), scriptfile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTgzArchive(File dstFile, List<MetaScript> scripts) throws IOException {
        FileOutputStream fos = new FileOutputStream(dstFile);
        GZIPOutputStream gzos = new GZIPOutputStream(fos);
        tos.setLongFileMode(2);
        try (TarOutputStream tos = new TarOutputStream((OutputStream)gzos);){
            for (MetaScript script : scripts) {
                byte[] content = script.content.getBytes(UTF8);
                String path = FilenameUtils.separatorsToUnix((String)script.file.getPath());
                TarEntry entry = new TarEntry(path);
                entry.setMode(511);
                entry.setSize((long)content.length);
                tos.putNextEntry(entry);
                tos.write(content);
                tos.closeEntry();
            }
        }
    }

    public static Map<String, String> getResolvedBuildParameters(AbstractBuild<?, ?> build) {
        if (build == null) {
            return Collections.emptyMap();
        }
        Set sensitive = build.getSensitiveBuildVariables();
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry e : build.getBuildVariables().entrySet()) {
            String val = sensitive.contains(e.getKey()) ? "" : (String)e.getValue();
            result.put((String)e.getKey(), val);
        }
        for (EnvironmentContributingAction a : build.getActions(EnvironmentContributingAction.class)) {
            EnvVars env = new EnvVars();
            a.buildEnvironment(build, env);
            for (Map.Entry e : env.entrySet()) {
                if (result.containsKey(e.getKey())) continue;
                String val = sensitive.contains(e.getKey()) ? "" : (String)e.getValue();
                result.put((String)e.getKey(), val);
            }
        }
        result.put("JENKINS_HOME", Jenkins.get().getRootDir().getAbsolutePath());
        HashMap<String, Integer> seen = new HashMap<String, Integer>();
        LinkedList open = new LinkedList(result.keySet());
        while (!open.isEmpty()) {
            String key = (String)open.pop();
            String value = (String)result.get(key);
            String resolved = Util.replaceMacro((String)value, result);
            if (resolved.equals(value)) continue;
            result.put(key, resolved);
            Integer depth = (Integer)seen.get(key);
            if (depth == null) {
                depth = 0;
            }
            if (depth >= 10) continue;
            seen.put(key, depth + 1);
            open.addLast(key);
        }
        return result;
    }

    public static Map<String, String> getResolvedBuildParameters(InheritanceProject project) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        List<ParameterDefinition> parameters = project.getParameters(InheritanceProject.IMode.INHERIT_FORCED);
        for (ParameterDefinition pDef : parameters) {
            ParameterValue pVal = pDef.getDefaultParameterValue();
            if (!(pVal instanceof StringParameterValue)) continue;
            String val = pVal.isSensitive() ? "" : ((StringParameterValue)pVal).getValue().toString();
            result.put(pDef.getName(), val);
        }
        return result;
    }

    public BuildFlowScriptActionDescriptor getDescriptor() {
        return (BuildFlowScriptActionDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    public static BuildFlowScriptActionDescriptor getDescriptorStatic() {
        return (BuildFlowScriptActionDescriptor)Jenkins.get().getDescriptorOrDie(BuildFlowScriptAction.class);
    }

    @Extension(ordinal=1000.0)
    public static final class BuildFlowScriptActionDescriptor
    extends Descriptor<BuildFlowScriptAction> {
        public String getDisplayName() {
            return "Inheritance View";
        }

        public ListBoxModel doFillProjectClassItems() {
            return InheritanceProject.DESCRIPTOR.doFillCreationClassItems();
        }
    }
}

