/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.inheritance;

import hudson.ExtensionList;
import hudson.cli.BuildCommand;
import hudson.model.Build;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Queue;
import hudson.model.Saveable;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.inheritance.InheritanceSelector;
import hudson.plugins.project_inheritance.projects.references.AbstractProjectReference;
import hudson.plugins.project_inheritance.projects.references.ProjectReference;
import hudson.plugins.project_inheritance.projects.versioning.VersionHandler;
import hudson.plugins.project_inheritance.util.Reflection;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildTrigger;
import hudson.triggers.Trigger;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import jenkins.model.ParameterizedJobMixIn;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class InheritanceGovernor<T> {
    public static final Pattern runUriRegExp = Pattern.compile(".*/job/[^/]+/[0-9]+/.*");
    public final String fieldName;
    public final ProjectReference.PrioComparator.SELECTOR orderMode;
    public final InheritanceProject caller;
    static Saveable NOOP = new Saveable(){

        public void save() throws IOException {
        }
    };

    public InheritanceGovernor(String field, ProjectReference.PrioComparator.SELECTOR order, InheritanceProject caller) {
        this.fieldName = field;
        this.orderMode = order;
        this.caller = caller;
    }

    protected abstract T castToDestinationType(Object var1);

    public abstract T getRawField(InheritanceProject var1);

    private final T noCopyCast(Object o) {
        T cast = this.castToDestinationType(o);
        if (cast != null && cast != o) {
            throw new ClassCastException("You MUST NOT cast by copying!");
        }
        return cast;
    }

    public T getVersionedField(InheritanceProject ip, Long version) {
        if (ip.getVersionedObjectStore().size() == 0) {
            return this.getRawField(ip);
        }
        Map<String, Object> map = ip.getVersionedObjectStore().getValueMapFor(version);
        if (map == null || map.isEmpty()) {
            return this.getRawField(ip);
        }
        if (map.containsKey(this.fieldName)) {
            Object obj = map.get(this.fieldName);
            if (obj == null) {
                return null;
            }
            return this.noCopyCast(obj);
        }
        return this.getRawField(ip);
    }

    public final T retrieveFullyDerivedField(InheritanceProject root, InheritanceProject.IMode mode) {
        boolean needsInheritance = false;
        boolean needsVersioning = false;
        switch (mode) {
            case INHERIT_FORCED: {
                needsInheritance = true;
                needsVersioning = true;
                break;
            }
            case LOCAL_ONLY: {
                needsInheritance = false;
                needsVersioning = true;
                break;
            }
            case AUTO: {
                needsInheritance = InheritanceGovernor.inheritanceLookupRequired(root);
                needsVersioning = InheritanceGovernor.versioningRequired();
            }
        }
        if (!needsInheritance && !needsVersioning) {
            return this.getRawField(root);
        }
        if (!needsInheritance) {
            return this.getVersionedField(root, VersionHandler.getVersion(root));
        }
        List<InheritanceProject> scope = this.getFullScopeOrdered(root, new HashSet<String>());
        LinkedList<T> allFields = new LinkedList<T>();
        for (InheritanceProject ip : scope) {
            Long version;
            T field = this.getVersionedField(ip, version = VersionHandler.getVersion(ip));
            if (field == null) continue;
            allFields.add(field);
        }
        return (T)this.reduceFromFullInheritance(allFields);
    }

    private final List<InheritanceProject> getFullScopeOrdered(InheritanceProject root, Set<String> seen) {
        return InheritanceGovernor.getFullScopeOrdered(root, this.orderMode, seen);
    }

    public static final List<InheritanceProject> getFullScopeOrdered(InheritanceProject root, ProjectReference.PrioComparator.SELECTOR order, Set<String> seen) {
        if (seen == null) {
            seen = new HashSet<String>();
        }
        LinkedList<InheritanceProject> all = new LinkedList<InheritanceProject>();
        if (root == null) {
            return all;
        }
        String name = root.getFullName();
        if (seen.contains(name)) {
            return all;
        }
        seen.add(name);
        LinkedList<InheritanceProject> priors = new LinkedList<InheritanceProject>();
        LinkedList<InheritanceProject> latters = new LinkedList<InheritanceProject>();
        for (AbstractProjectReference apr : root.getParentReferences(order)) {
            InheritanceProject ip;
            if (apr == null || (ip = apr.getProject()) == null) continue;
            int prio = ProjectReference.PrioComparator.getPriorityFor(apr, order);
            if (prio <= 0) {
                priors.addAll(InheritanceGovernor.getFullScopeOrdered(ip, order, seen));
                continue;
            }
            latters.addAll(InheritanceGovernor.getFullScopeOrdered(ip, order, seen));
        }
        all.addAll(0, priors);
        all.add(root);
        all.addAll(latters);
        return all;
    }

    protected T reduceFromFullInheritance(Deque<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Iterator<T> iter = list.descendingIterator();
        while (iter.hasNext()) {
            T obj = iter.next();
            if (obj == null) continue;
            return obj;
        }
        return list.peekLast();
    }

    protected static <R> List<R> reduceByMergeWithDuplicates(Deque<List<R>> list, Class<?> listType, InheritanceProject caller) {
        List merge = new LinkedList();
        if (list == null) {
            return merge;
        }
        for (Collection collection : list) {
            merge.addAll(collection);
        }
        if (merge.isEmpty()) {
            return merge;
        }
        ExtensionList<InheritanceSelector> isLst = InheritanceSelector.all();
        for (InheritanceSelector is : isLst) {
            if (!is.isApplicableFor(listType)) continue;
            InheritanceSelector isr = is;
            merge = isr.applyAgainstList(merge, caller);
        }
        return merge;
    }

    protected static <R> List<R> reduceByMerge(Deque<List<R>> list, Class<?> listType, InheritanceProject caller) {
        List<R> merge = InheritanceGovernor.reduceByMergeWithDuplicates(list, listType, caller);
        LinkedList<R> out = new LinkedList<R>(merge);
        HashSet seen = new HashSet();
        Iterator<R> rIter = out.descendingIterator();
        while (rIter.hasNext()) {
            R entry = rIter.next();
            Class<?> clazz = entry.getClass();
            if (seen.contains(clazz)) {
                rIter.remove();
                continue;
            }
            seen.add(clazz);
        }
        return out;
    }

    protected static <R extends Describable<R>> DescribableList<R, Descriptor<R>> reduceDescribableByMerge(Deque<DescribableList<R, Descriptor<R>>> list) {
        if (list == null) {
            return new DescribableList(NOOP);
        }
        LinkedList<Describable> merge = new LinkedList<Describable>();
        for (DescribableList<R, Descriptor<R>> sub : list) {
            for (Describable item : sub) {
                merge.add(item);
            }
        }
        return new DescribableList(NOOP, merge);
    }

    protected static <R extends Describable<R>> DescribableList<R, Descriptor<R>> reduceDescribableByMergeWithoutDuplicates(Deque<DescribableList<R, Descriptor<R>>> list) {
        HashSet seen = new HashSet();
        if (list == null) {
            return new DescribableList(NOOP);
        }
        LinkedList<Describable> merge = new LinkedList<Describable>();
        Iterator<DescribableList<R, Descriptor<R>>> rIter = list.descendingIterator();
        while (rIter.hasNext()) {
            DescribableList<R, Descriptor<R>> sub = rIter.next();
            for (Describable item : sub) {
                Class<?> clazz = item.getClass();
                if (seen.contains(clazz)) continue;
                merge.add(item);
                seen.add(clazz);
            }
        }
        return new DescribableList(NOOP, merge);
    }

    protected static <R> List<R> castToList(Object o) {
        try {
            if (o instanceof List) {
                return (List)o;
            }
            return null;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    protected static <R extends Describable<R>> DescribableList<R, Descriptor<R>> castToDescribableList(Object o) {
        try {
            if (o instanceof DescribableList) {
                return (DescribableList)o;
            }
            return null;
        }
        catch (ClassCastException ex) {
            return null;
        }
    }

    public static boolean inheritanceLookupRequired(InheritanceProject root) {
        return InheritanceGovernor.inheritanceLookupRequired(root, false);
    }

    public static boolean inheritanceLookupRequired(InheritanceProject root, boolean forcedInherit) {
        try {
            if (root.hasCyclicDependency()) {
                return false;
            }
        }
        catch (NullPointerException ex) {
            return false;
        }
        if (forcedInherit || root.getIsTransient()) {
            return true;
        }
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null) {
            String uri = req.getRequestURI();
            if (uri.endsWith("/build")) {
                return true;
            }
            if (runUriRegExp.matcher(uri).matches()) {
                return true;
            }
        }
        return Reflection.calledFromClass(Build.class, BuildCommand.class, Queue.class, BuildTrigger.class, Trigger.class, BuildStep.class, ParameterizedJobMixIn.class) || Reflection.calledFromMethod(InheritanceProject.class, "doBuild", "scheduleBuild2", "doBuildWithParameters");
    }

    protected static boolean versioningRequired() {
        return !Reflection.calledFromMethod(Project.class, "submit");
    }
}

