/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.creation;

import com.google.common.base.Joiner;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Functions;
import hudson.XmlFile;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ManagementLink;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.listeners.ItemListener;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.creation.Messages;
import hudson.plugins.project_inheritance.projects.creation.ProjectTemplate;
import hudson.plugins.project_inheritance.projects.references.AbstractProjectReference;
import hudson.plugins.project_inheritance.projects.references.ParameterizedProjectReference;
import hudson.plugins.project_inheritance.projects.references.ProjectReference;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ProjectCreationEngine
extends ManagementLink
implements Saveable,
Describable<ProjectCreationEngine> {
    private static final Logger log = Logger.getLogger(ProjectCreationEngine.class.toString());
    @Extension(ordinal=100.0)
    public static final ProjectCreationEngine instance = new ProjectCreationEngine();
    protected static LinkedList<Descriptor<CreationClass>> creationClassesDescriptors = null;
    protected static LinkedList<Descriptor<CreationMating>> matingDescriptors = null;
    protected LinkedList<CreationClass> creationClasses = new LinkedList();
    protected LinkedList<CreationMating> matings = new LinkedList();
    protected boolean disallowVanillaArchiver = false;
    protected boolean enableCreation = false;
    protected boolean triggerOnChange = true;
    protected boolean triggerOnStartup = true;
    protected boolean copyOnRename = true;
    protected boolean enableApplyButton = true;
    protected final transient Boolean enableLeakedLogCleaner = null;
    protected List<String> acceptableErrorUrls;
    protected RenameRestriction renameRestriction = RenameRestriction.ALLOW_ALL;
    protected transient Map<String, String> lastCreationState = new ConcurrentHashMap<String, String>();
    protected final transient Executor creationExecutor = Executors.newFixedThreadPool(1);
    protected List<ProjectTemplate> templates = new LinkedList<ProjectTemplate>();

    private ProjectCreationEngine() {
        if (instance != null) {
            throw new IllegalStateException("Not allowed to create a second instance of ProjectCreationEngine");
        }
        XmlFile xml = new XmlFile(Jenkins.XSTREAM, this.getConfigFile());
        if (xml.exists()) {
            try {
                ProjectCreationEngine pce;
                boolean success;
                Object obj = xml.read();
                if (obj instanceof ProjectCreationEngine && !(success = this.copyFrom(pce = (ProjectCreationEngine)((Object)obj)))) {
                    log.severe("Could not use PCE configuration loaded from disk");
                }
            }
            catch (IOException e) {
                log.severe("Could not read PCE configuration from disk: " + e.toString());
            }
        }
    }

    public Object readResolve() {
        if (this.templates == null) {
            this.templates = new LinkedList<ProjectTemplate>();
        }
        return this;
    }

    private boolean copyFrom(ProjectCreationEngine other) {
        Class<?> cl = ((Object)((Object)this)).getClass();
        for (Field f : cl.getDeclaredFields()) {
            if (f.getName().equals("instance") || f.getName().equals("createdClassesDescriptors") || f.getName().equals("matingDescriptors") || f.isSynthetic()) continue;
            try {
                Object otherVal = f.get((Object)other);
                f.set((Object)this, otherVal);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        XmlFile xml = new XmlFile(Jenkins.XSTREAM, this.getConfigFile());
        xml.write((Object)this);
    }

    @RequirePOST
    public synchronized void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        try (BulkChange bc = new BulkChange((Saveable)this);){
            boolean result = true;
            JSONObject json = req.getSubmittedForm();
            try {
                this.disallowVanillaArchiver = json.getBoolean("disallowVanillaArchiver");
            }
            catch (JSONException ex) {
                this.disallowVanillaArchiver = false;
            }
            try {
                this.enableCreation = json.getBoolean("enableCreation");
            }
            catch (JSONException ex) {
                this.enableCreation = false;
            }
            try {
                this.triggerOnChange = json.getBoolean("triggerOnChange");
            }
            catch (JSONException ex) {
                this.triggerOnChange = false;
            }
            try {
                this.triggerOnStartup = json.getBoolean("triggerOnStartup");
            }
            catch (JSONException ex) {
                this.triggerOnStartup = false;
            }
            try {
                this.copyOnRename = json.getBoolean("copyOnRename");
            }
            catch (JSONException ex) {
                this.copyOnRename = false;
            }
            try {
                this.enableApplyButton = json.getBoolean("enableApplyButton");
            }
            catch (JSONException ex) {
                this.enableApplyButton = true;
            }
            try {
                this.renameRestriction = RenameRestriction.valueOf(json.getString("renameRestriction"));
            }
            catch (JSONException ex) {
                this.renameRestriction = RenameRestriction.ALLOW_ALL;
            }
            try {
                LinkedList<String> acceptUrls = new LinkedList<String>();
                for (String line : json.getString("acceptableErrorUrls").split("\n")) {
                    if (!StringUtils.isNotBlank((String)(line = line.trim()))) continue;
                    acceptUrls.add(line);
                }
                this.acceptableErrorUrls = acceptUrls;
            }
            catch (JSONException ex) {
                this.acceptableErrorUrls = Collections.emptyList();
            }
            Object obj = json.get("creationClasses");
            if (obj != null) {
                List refs = CreationClass.DescriptorImpl.newInstancesFromHeteroList((StaplerRequest)req, (Object)obj, ProjectCreationEngine.getCreationClassesDescriptors());
                this.creationClasses.clear();
                this.creationClasses.addAll(refs);
            } else {
                this.creationClasses.clear();
            }
            obj = json.get("matings");
            if (obj != null) {
                List mates = CreationMating.DescriptorImpl.newInstancesFromHeteroList((StaplerRequest)req, (Object)obj, ProjectCreationEngine.getMatingDescriptors());
                HashMap<String, CreationMating> unifier = new HashMap<String, CreationMating>();
                for (CreationMating mating : mates) {
                    if (mating.firstClass == null || mating.firstClass.isEmpty() || mating.secondClass == null || mating.secondClass.isEmpty()) continue;
                    String key = "first:" + mating.firstClass + ",second:" + mating.secondClass;
                    unifier.put(key, mating);
                }
                this.matings.clear();
                this.matings.addAll(unifier.values());
            } else {
                this.matings.clear();
            }
            obj = json.get("templates");
            if (obj != null) {
                List templates = req.bindJSONToList(ProjectTemplate.class, obj);
                this.templates.clear();
                this.templates.addAll(templates);
                HashSet<String> seen = new HashSet<String>();
                Iterator<ProjectTemplate> iter = this.templates.iterator();
                while (iter.hasNext()) {
                    String name = iter.next().getName();
                    if (seen.add(name)) continue;
                    iter.remove();
                }
            } else {
                this.templates.clear();
            }
            if (result) {
                rsp.sendRedirect(req.getContextPath() + "/manage");
            } else {
                rsp.sendRedirect("project_creation");
            }
            bc.commit();
        }
    }

    public synchronized Map<String, String> triggerCreateProjects() {
        ConcurrentHashMap<String, String> reportMap = new ConcurrentHashMap<String, String>();
        if (!this.enableCreation) {
            return reportMap;
        }
        long startTime = System.currentTimeMillis();
        int numExecs = Runtime.getRuntime().availableProcessors();
        if (numExecs > 1) {
            --numExecs;
        }
        ExecutorService exec = Executors.newFixedThreadPool(numExecs);
        LinkedList<Future> futures = new LinkedList<Future>();
        Map<String, InheritanceProject> pMap = InheritanceProject.getProjectsMap();
        for (InheritanceProject firstP : pMap.values()) {
            List<AbstractProjectReference> refs = firstP.getCompatibleProjects();
            for (AbstractProjectReference ref : refs) {
                InheritanceProject secondP = ref.getProject();
                if (secondP == null) continue;
                String variance = ref instanceof ParameterizedProjectReference ? ((ParameterizedProjectReference)ref).getVariance() : null;
                InheritanceProject[] parents = new InheritanceProject[]{firstP, secondP};
                ProjectDerivationRunner pdr = new ProjectDerivationRunner(parents, variance, reportMap, ACL.SYSTEM);
                futures.add(exec.submit(pdr, true));
            }
        }
        exec.shutdown();
        Future f = null;
        while (!futures.isEmpty()) {
            try {
                f = (Future)futures.pop();
                Boolean result = (Boolean)f.get(10L, TimeUnit.SECONDS);
                if (result != null && result.booleanValue()) continue;
                log.warning("Future object for creation did not return in time");
                futures.addLast(f);
            }
            catch (InterruptedException ex) {
                log.severe("Transient project creation was interruped!");
            }
            catch (ExecutionException ex) {
                log.severe("Transient project creation failed!");
                log.severe(ex.toString());
            }
            catch (TimeoutException ex) {
                if (f != null) {
                    futures.addLast(f);
                }
                f = null;
            }
        }
        long endTime = System.currentTimeMillis();
        double diffSecs = (double)(endTime - startTime) / 1000.0;
        DecimalFormat form = new DecimalFormat();
        form.setMaximumFractionDigits(3);
        log.info("Transient project creation was finished in " + form.format(diffSecs) + " seconds");
        return reportMap;
    }

    @RequirePOST
    public void doCreateProjects(StaplerRequest req, StaplerResponse rsp) {
        try {
            if (!Jenkins.get().hasPermission(Job.CREATE)) {
                rsp.sendError(403, "User lacks the Job.CREATE permission");
                return;
            }
            this.lastCreationState = this.triggerCreateProjects();
            Jenkins j = Jenkins.get();
            String rootURL = j.getRootUrlFromRequest();
            rsp.sendRedirect(rootURL + "/project_creation/showCreationResults");
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void notifyJenkinsStartupComplete() {
        if (this.enableCreation && this.triggerOnStartup) {
            this.lastCreationState = this.triggerCreateProjects();
        }
    }

    public void notifyProjectChange(InheritanceProject project) {
        if (this.enableCreation && this.triggerOnChange) {
            this.creationExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ProjectCreationEngine.this.lastCreationState = ProjectCreationEngine.this.triggerCreateProjects();
                }
            });
        }
    }

    public void notifyProjectNew(InheritanceProject project) {
        if (this.enableCreation && this.triggerOnChange) {
            this.creationExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ProjectCreationEngine.this.lastCreationState = ProjectCreationEngine.this.triggerCreateProjects();
                }
            });
        }
    }

    public void notifyProjectDelete(InheritanceProject project) {
    }

    public String getDisplayName() {
        return Messages.ProjectCreationEngine_DisplayName();
    }

    public String getIconFileName() {
        return "/plugin/project-inheritance/images/48x48/BinaryTree.png";
    }

    public String getUrlName() {
        return "project_creation";
    }

    public String getDescription() {
        return Messages.ProjectCreationEngine_Description();
    }

    public boolean getEnableReflectionCaching() {
        return true;
    }

    public boolean getEnableCreation() {
        return this.enableCreation;
    }

    public boolean getTriggerOnChange() {
        return this.triggerOnChange;
    }

    public boolean getTriggerOnStartup() {
        return this.triggerOnStartup;
    }

    public boolean getCopyOnRename() {
        return this.copyOnRename;
    }

    public boolean getEnableApplyButton() {
        return this.enableApplyButton;
    }

    public RenameRestriction getRenameRestrictionValue() {
        if (this.renameRestriction == null) {
            return RenameRestriction.ALLOW_ALL;
        }
        return this.renameRestriction;
    }

    public String getRenameRestriction() {
        return this.getRenameRestrictionValue().name();
    }

    public boolean currentUserMayRename() {
        switch (this.getRenameRestrictionValue()) {
            default: {
                return true;
            }
            case DISALLOW_ALL: {
                return false;
            }
            case ALLOW_ADMIN: 
        }
        try {
            return Functions.hasPermission((Permission)Jenkins.ADMINISTER);
        }
        catch (IOException e) {
            return false;
        }
        catch (ServletException e) {
            return false;
        }
    }

    public boolean getDisallowVanillaArchiver() {
        return this.disallowVanillaArchiver;
    }

    public String getAcceptableErrorUrls() {
        return Joiner.on((char)'\n').join(this.getAcceptableErrorUrlsList());
    }

    public List<String> getAcceptableErrorUrlsList() {
        if (this.acceptableErrorUrls == null) {
            this.acceptableErrorUrls = new LinkedList<String>(Arrays.asList("hudson.tasks.ArtifactArchiver", "hudson.tasks.junit.JUnitResultArchiver"));
        }
        return this.acceptableErrorUrls;
    }

    public List<CreationClass> getCreationClasses() {
        return this.creationClasses;
    }

    public static List<Descriptor<CreationClass>> getCreationClassesDescriptors() {
        if (creationClassesDescriptors == null) {
            creationClassesDescriptors = new LinkedList();
            creationClassesDescriptors.add(CreationClass.DESCRIPTOR);
        }
        return creationClassesDescriptors;
    }

    public List<CreationMating> getMatings() {
        return this.matings;
    }

    public boolean isFirstInCreationMating(String creationClass) {
        for (CreationMating creationMating : this.matings) {
            if (creationMating.firstClass == null || !creationMating.firstClass.equals(creationClass)) continue;
            return true;
        }
        return false;
    }

    public static List<Descriptor<CreationMating>> getMatingDescriptors() {
        if (matingDescriptors == null) {
            matingDescriptors = new LinkedList();
            matingDescriptors.add(CreationMating.DESCRIPTOR);
        }
        return matingDescriptors;
    }

    public List<ProjectTemplate> getTemplates() {
        if (this.templates == null) {
            return Collections.emptyList();
        }
        return this.templates;
    }

    protected File getConfigFile() {
        File root = Jenkins.get().getRootDir();
        return new File(root, "config_project_creation.xml");
    }

    public Map<String, String> getLastCreationState() {
        return this.lastCreationState;
    }

    public void setEnableCreation(boolean enabled) {
        this.enableCreation = enabled;
    }

    private Map<String, LinkedList<InheritanceProject>> getProjectsByClass() {
        HashMap<String, LinkedList<InheritanceProject>> classMap = new HashMap<String, LinkedList<InheritanceProject>>();
        Map<String, InheritanceProject> projectMap = InheritanceProject.getProjectsMap();
        for (InheritanceProject ip : projectMap.values()) {
            String dc = ip.getCreationClass();
            if (dc == null || dc.isEmpty()) continue;
            if (classMap.containsKey(dc)) {
                classMap.get(dc).push(ip);
                continue;
            }
            LinkedList<InheritanceProject> lst = new LinkedList<InheritanceProject>();
            lst.push(ip);
            classMap.put(dc, lst);
        }
        return classMap;
    }

    private int getNumOfMates(String firstClass, String secondClass) {
        Map<String, LinkedList<InheritanceProject>> map = this.getProjectsByClass();
        if (map.containsKey(firstClass) && map.containsKey(secondClass)) {
            LinkedList<InheritanceProject> firsts = map.get(firstClass);
            LinkedList<InheritanceProject> seconds = map.get(secondClass);
            return firsts.size() * seconds.size();
        }
        return 0;
    }

    public static final String generateNameFor(String variance, List<String> projects) {
        if (projects == null || projects.size() == 0) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        Iterator<String> iter = projects.iterator();
        while (iter.hasNext()) {
            b.append(iter.next());
            if (!iter.hasNext()) continue;
            b.append('_');
        }
        if (variance != null && !variance.isEmpty()) {
            b.append('_');
            b.append(variance.trim());
        }
        return b.toString();
    }

    public static final String generateNameFor(String variance, String ... projects) {
        if (projects == null || projects.length == 0) {
            return null;
        }
        return ProjectCreationEngine.generateNameFor(variance, Arrays.asList(projects));
    }

    public Descriptor<ProjectCreationEngine> getDescriptor() {
        return (ProjectCreationEngineDescriptor)Jenkins.get().getDescriptorOrDie(ProjectCreationEngine.class);
    }

    @Extension
    public static class ProjectCreationEngineDescriptor
    extends Descriptor<ProjectCreationEngine> {
        public ListBoxModel doFillRenameRestrictionItems() {
            ListBoxModel m = new ListBoxModel();
            for (RenameRestriction r : RenameRestriction.values()) {
                m.add(r.toString(), r.name());
            }
            return m;
        }

        public String getDisplayName() {
            return Messages.ProjectCreationEngine_DisplayName();
        }
    }

    private static class ProjectDerivationRunner
    implements Runnable {
        private final InheritanceProject[] parents;
        private final String variance;
        private final Map<String, String> reportMap;
        private final Authentication auth;
        private static final ReentrantLock lock = new ReentrantLock();

        public ProjectDerivationRunner(InheritanceProject[] parents, String variance, Map<String, String> reportMap, Authentication auth) {
            if (parents == null || parents.length <= 0) {
                throw new IllegalArgumentException("You must offer at least one parent to create a new derived project.");
            }
            this.parents = parents;
            this.variance = variance != null ? variance.trim() : null;
            this.reportMap = reportMap;
            this.auth = auth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProjectCreationEngine pce = instance;
            LinkedList<String> parNames = new LinkedList<String>();
            LinkedList<String> classes = new LinkedList<String>();
            for (InheritanceProject ip : this.parents) {
                if (ip == null) continue;
                String pName = ip.getFullName();
                String cName = ip.getCreationClass();
                if (pName == null || cName == null || cName.isEmpty()) continue;
                parNames.add(pName);
                classes.add(cName);
            }
            String pName = ProjectCreationEngine.generateNameFor(this.variance, parNames);
            if (classes.size() < 2 || classes.contains(null)) {
                this.reportMap.put(pName, "At least one parent is not a member of a class");
                return;
            }
            String leftClass = (String)classes.get(0);
            String rightClass = (String)classes.get(1);
            boolean isValidMate = false;
            for (CreationMating mate : pce.getMatings()) {
                if (!mate.firstClass.equals(leftClass) || !mate.secondClass.equals(rightClass)) continue;
                isValidMate = true;
                break;
            }
            if (!isValidMate) {
                this.reportMap.put(pName, String.format("Parents have incompatible classes: %s<->%s", leftClass, rightClass));
                return;
            }
            Map itemMap = Jenkins.get().getItemMap();
            SecurityContext oldAuthContext = null;
            lock.lock();
            try {
                if (this.auth != null) {
                    oldAuthContext = ACL.impersonate((Authentication)this.auth);
                }
                if (itemMap.containsKey(pName)) {
                    this.reportMap.put(pName, "Job already exists");
                    return;
                }
                if (this.reportMap.containsKey(pName)) {
                    return;
                }
                InheritanceProject.DESCRIPTOR.addProjectToBeCreatedTransient(pName);
                TopLevelItem item = null;
                InheritanceProject ip = null;
                item = Jenkins.get().createProject((TopLevelItemDescriptor)InheritanceProject.DESCRIPTOR, pName);
                if (item == null || !(item instanceof InheritanceProject)) {
                    item.delete();
                    this.reportMap.put(pName, "Failed, wrong project type generated");
                    return;
                }
                ip = (InheritanceProject)item;
                int i = 0;
                for (InheritanceProject par : this.parents) {
                    if (par == null) continue;
                    ip.addParentReference(new ProjectReference(par.getFullName(), --i));
                }
                if (this.variance != null && !this.variance.isEmpty()) {
                    ip.setVarianceLabel(this.variance);
                }
                boolean isSane = false;
                String insanityMessage = null;
                AbstractMap.SimpleEntry<Boolean, String> sanity = ip.getParameterSanity();
                if (!sanity.getKey().booleanValue()) {
                    insanityMessage = "Failed, resulting project has parameter error: " + sanity.getValue();
                } else if (ip.hasCyclicDependency()) {
                    insanityMessage = "Failed, resulting project has cyclic dependency.";
                } else if (!ip.isBuildable()) {
                    insanityMessage = "Failed, resulting project is not buildable.";
                } else {
                    isSane = true;
                }
                if (ip != null) {
                    ip.onLoad((ItemGroup<? extends Item>)ip.getParent(), ip.getFullName());
                }
                if (!isSane) {
                    this.reportMap.put(pName, insanityMessage);
                } else {
                    this.reportMap.put(pName, "Success");
                }
            }
            catch (IllegalArgumentException ex) {
                this.reportMap.put(pName, "Job already exists");
            }
            catch (IOException ex) {
                log.warning("Could not generate project " + pName + " due to I/O-Error");
                this.reportMap.put(pName, "Failed, I/O Error");
            }
            catch (InterruptedException ex) {
                log.severe("Created broken project " + pName + " but could not remove it.");
                this.reportMap.put(pName, "FATAL! Wrong project created; but could not delete");
            }
            finally {
                InheritanceProject.DESCRIPTOR.dropProjectToBeCreatedTransient(pName);
                if (oldAuthContext != null) {
                    SecurityContextHolder.setContext((SecurityContext)oldAuthContext);
                }
                lock.unlock();
            }
        }
    }

    @Extension
    public static class RenameWatcher
    extends ItemListener {
        public void onDeleted(Item item) {
            ListIterator<ProjectTemplate> iter = instance.getTemplates().listIterator();
            while (iter.hasNext()) {
                ProjectTemplate t = iter.next();
                if (!t.getName().equalsIgnoreCase(item.getFullName())) continue;
                iter.remove();
            }
        }

        public void onRenamed(Item item, String oldName, String newName) {
            ListIterator<ProjectTemplate> iter = instance.getTemplates().listIterator();
            while (iter.hasNext()) {
                ProjectTemplate t = iter.next();
                if (!t.getName().equalsIgnoreCase(oldName)) continue;
                iter.set(new ProjectTemplate(newName, t.getShortDescription()));
            }
            try {
                instance.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class CreationMating
    extends AbstractDescribableImpl<CreationMating> {
        public final String firstClass;
        public final String secondClass;
        public final String description;
        @Extension(ordinal=1000.0)
        public static final Descriptor<CreationMating> DESCRIPTOR = new DescriptorImpl();

        @DataBoundConstructor
        public CreationMating(String firstClass, String secondClass, String description) {
            this.firstClass = firstClass;
            this.secondClass = secondClass;
            this.description = description;
        }

        public static final class DescriptorImpl
        extends Descriptor<CreationMating> {
            public String getDisplayName() {
                return Messages.CreationMating_DisplayName();
            }

            public CreationMating newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
                CreationMating ref = (CreationMating)super.newInstance(req, formData);
                return ref;
            }

            public FormValidation doCheckFirstClass(@QueryParameter String firstClass, @QueryParameter String secondClass) {
                if (firstClass.isEmpty() || secondClass.isEmpty()) {
                    return FormValidation.error((String)"You need to specify two valid class names.");
                }
                if (firstClass.equals(secondClass)) {
                    return FormValidation.error((String)"You may not mate a type with itself.");
                }
                return FormValidation.ok();
            }

            public FormValidation doCheckSecondClass(@QueryParameter String firstClass, @QueryParameter String secondClass) {
                return this.doCheckFirstClass(firstClass, secondClass);
            }

            public FormValidation doCheckNumberOfMates(@QueryParameter(value="firstClass") String firstClass, @QueryParameter(value="secondClass") String secondClass) {
                int numOfMates = instance.getNumOfMates(firstClass, secondClass);
                String msg = "Will generate " + numOfMates + " mated projects";
                if (numOfMates > 0) {
                    return FormValidation.okWithMarkup((String)msg);
                }
                return FormValidation.error((String)msg);
            }

            public ListBoxModel doFillFirstClassItems() {
                ListBoxModel names = new ListBoxModel();
                for (CreationClass cl : ProjectCreationEngine.instance.creationClasses) {
                    names.add(cl.name);
                }
                return names;
            }

            public ListBoxModel doFillSecondClassItems() {
                return this.doFillFirstClassItems();
            }
        }
    }

    public static class CreationClass
    extends AbstractDescribableImpl<CreationClass> {
        public final String name;
        public final String description;
        @Extension(ordinal=1000.0)
        public static final Descriptor<CreationClass> DESCRIPTOR = new DescriptorImpl();

        @DataBoundConstructor
        public CreationClass(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public int getNumberOfProjects() {
            Map map = instance.getProjectsByClass();
            try {
                return ((LinkedList)map.get(this.name)).size();
            }
            catch (NullPointerException ex) {
                return 0;
            }
        }

        public static final class DescriptorImpl
        extends Descriptor<CreationClass> {
            public String getDisplayName() {
                return Messages.CreationClass_DisplayName();
            }

            public CreationClass newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
                CreationClass ref = (CreationClass)super.newInstance(req, formData);
                return ref;
            }
        }
    }

    public static enum RenameRestriction {
        ALLOW_ALL,
        ALLOW_ADMIN,
        DISALLOW_ALL;


        public String toString() {
            switch (this) {
                case ALLOW_ALL: {
                    return "Always allow renaming";
                }
                case ALLOW_ADMIN: {
                    return "Only allow for Admins";
                }
                case DISALLOW_ALL: {
                    return "Disallow completely";
                }
            }
            return "N/A";
        }
    }
}

