/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util.svg.primitives;

import hudson.plugins.project_inheritance.util.svg.primitives.SVGPrimitive;
import hudson.plugins.project_inheritance.util.svg.properties.TextProperty;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jfree.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGText
implements SVGPrimitive {
    private final Point2D.Double pos;
    private final TextProperty props;
    private double lineBreakPxls;
    private transient FontMetrics fm = null;
    private transient Graphics2D g = null;
    private transient Rectangle2D.Double bounds = null;

    public SVGText(Point2D.Double pos, TextProperty props, double lineBreakPxls) {
        if (pos == null || props == null) {
            throw new IllegalArgumentException("Null values for position or text-property not allowed.");
        }
        this.pos = pos;
        this.props = props;
        this.lineBreakPxls = lineBreakPxls;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("\"");
        for (int i = 0; i < this.props.text.length; ++i) {
            b.append(this.props.text[i]);
            if (i + 1 >= this.props.text.length) continue;
            b.append('\n');
        }
        b.append('\"');
        return b.toString();
    }

    @Override
    public Element render(Document doc) {
        Element txtElem = doc.createElement("text");
        txtElem.setAttribute("font-family", this.props.fontName);
        txtElem.setAttribute("font-size", String.format("%dpx", this.props.getSizeAsPts()));
        txtElem.setAttribute("x", Double.toString(this.pos.x));
        txtElem.setAttribute("y", Double.toString(this.pos.y + (double)this.getHeightOfLine()));
        switch (this.props.style) {
            default: {
                break;
            }
            case BOLD: {
                txtElem.setAttribute("font-weight", "bold");
                break;
            }
            case BOLDITALIC: {
                txtElem.setAttribute("font-weight", "bold");
                txtElem.setAttribute("font-style", "italic");
                break;
            }
            case ITALIC: {
                txtElem.setAttribute("font-style", "italic");
            }
        }
        Collection<String> lines = this.getBrokenLines();
        int lineHeight = this.getHeightOfLine();
        boolean isFirst = true;
        for (String line : lines) {
            Element e = doc.createElement("tspan");
            e.appendChild(doc.createTextNode(line));
            e.setAttribute("x", Double.toString(this.pos.x));
            if (!isFirst) {
                e.setAttribute("dy", Double.toString(lineHeight));
            } else {
                isFirst = false;
            }
            txtElem.appendChild(e);
        }
        return txtElem;
    }

    @Override
    public void translate(Point2D.Double offset) {
        if (offset == null) {
            return;
        }
        this.pos.x += offset.x;
        this.pos.y += offset.y;
        this.bounds = null;
    }

    @Override
    public void moveTo(Point2D.Double pos) {
        if (pos == null) {
            return;
        }
        this.pos.x = pos.x;
        this.pos.y = pos.y;
        this.bounds = null;
    }

    @Override
    public void rescale(double factor, boolean applyToStyles) {
        if (this.lineBreakPxls > 0.0) {
            this.lineBreakPxls *= factor;
        }
        if (applyToStyles) {
            this.props.fontSzPx = (int)((double)this.props.fontSzPx * factor);
            this.props.horizLineDist = (int)((double)this.props.horizLineDist * factor);
        }
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            Collection<String> lines = this.getBrokenLines();
            int lineOffsetY = this.getHeightOfLine() + this.props.horizLineDist;
            int heightOfAllLines = lines.size() * lineOffsetY;
            int maxWidth = 0;
            for (String line : lines) {
                maxWidth = Math.max(maxWidth, this.getWidthOfLine(line));
            }
            this.bounds = new Rectangle2D.Double(this.pos.x, this.pos.y, maxWidth, heightOfAllLines);
        }
        return this.bounds;
    }

    @Override
    public List<Point2D.Double> getAttachmentPoints() {
        return null;
    }

    private void initFontMetrics() {
        if (this.g == null) {
            this.g = new BufferedImage(1, 1, 1).createGraphics();
        }
        if (this.fm == null) {
            Font font = new Font(this.props.fontName, this.props.getAwtFontStyle(), this.props.getSizeAsPts());
            this.g.setFont(font);
            this.fm = this.g.getFontMetrics();
        }
    }

    protected int getWidthOfLine(String line) {
        this.initFontMetrics();
        if (line == null || line.isEmpty()) {
            return 0;
        }
        TextLayout tl = new TextLayout(line, this.fm.getFont(), this.g.getFontRenderContext());
        int advance = (int)Math.ceil(tl.getAdvance());
        return advance;
    }

    protected int getHeightOfLine() {
        this.initFontMetrics();
        return this.fm.getHeight();
    }

    protected Collection<String> getBrokenLine(String line) {
        this.initFontMetrics();
        LinkedList<String> out = new LinkedList<String>();
        if (line == null || line.isEmpty()) {
            return out;
        }
        HashMap<TextAttribute, Font> attributes = new HashMap<TextAttribute, Font>();
        attributes.put(TextAttribute.FONT, this.g.getFont());
        AttributedString as = new AttributedString(line, attributes);
        AttributedCharacterIterator aci = as.getIterator();
        LineBreakMeasurer measurer = new LineBreakMeasurer(aci, this.g.getFontRenderContext());
        int start = 0;
        while (true) {
            TextLayout tl = measurer.nextLayout((float)this.lineBreakPxls);
            if (start >= line.length() || tl == null) {
                if (start >= line.length()) break;
                out.add(line.substring(start, line.length()));
                break;
            }
            int end = measurer.getPosition();
            String text = line.substring(start, end);
            float lenInPx = tl.getAdvance();
            if ((double)lenInPx > this.lineBreakPxls) {
                Log.error((Object)String.format("Line breaker error: String '%s' is %fpx wide, but should be < %fpx", text, Float.valueOf(lenInPx), this.lineBreakPxls));
            }
            out.add(text);
            start = end;
        }
        return out;
    }

    protected Collection<String> getBrokenLines() {
        if (this.lineBreakPxls <= 0.0) {
            return Arrays.asList(this.props.text);
        }
        LinkedList<String> lines = new LinkedList<String>();
        for (String line : this.props.text) {
            lines.addAll(this.getBrokenLine(line));
        }
        return lines;
    }
}

