/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class Resolver {
    public static String[] resolve(VariableResolver<String> resolver, String ... in) {
        String[] mods = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            mods[i] = Resolver.resolveSingle(resolver, in[i]);
        }
        return mods;
    }

    public static String[] resolve(Map<String, String> map, String ... in) {
        String[] mods = new String[in.length];
        for (int i = 0; i < in.length; ++i) {
            mods[i] = Resolver.resolveSingle(map, in[i]);
        }
        return mods;
    }

    public static String resolveSingle(VariableResolver<String> resolver, String in) {
        String curr = in;
        String out = null;
        for (int i = 0; i < 10; ++i) {
            out = Util.replaceMacro((String)curr, resolver);
            if (out == curr) {
                return out;
            }
            curr = out;
        }
        return out;
    }

    public static String resolveSingle(Map<String, String> map, String in) {
        String curr = in;
        String out = null;
        for (int i = 0; i < 10; ++i) {
            out = Util.replaceMacro((String)curr, map);
            if (out == curr) {
                return out;
            }
            curr = out;
        }
        return out;
    }

    public static Map<String, String> getEnvFor(AbstractBuild<?, ?> build, TaskListener log) {
        HashMap<String, String> evMap = new HashMap<String, String>();
        evMap.putAll(build.getBuildVariables());
        try {
            evMap.putAll((Map<String, String>)build.getEnvironment(log));
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return evMap;
    }

    public static String[] splitCommas(String in) {
        if (in == null) {
            return new String[0];
        }
        String[] split = in.split("(?<!\\\\),");
        Vector<String> vec = new Vector<String>();
        for (String str : split) {
            String trim = str.trim();
            if (trim.isEmpty()) continue;
            vec.add(trim.replaceAll("\\,", ","));
        }
        String[] ret = new String[vec.size()];
        return vec.toArray(ret);
    }

    public static String joinWithCommas(String ... in) {
        if (in == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < in.length; ++i) {
            String glob = in[i].replaceAll(",", "\\,");
            b.append(glob);
            if (i >= in.length - 1) continue;
            b.append(", ");
        }
        return b.toString();
    }
}

