/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.versioning;

import hudson.model.AbstractProject;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.util.LimitedHashMap;
import hudson.plugins.project_inheritance.util.ThreadAssocStore;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class VersionHandler {
    private static final Logger log = Logger.getLogger(VersionHandler.class.toString());
    public static final String SINGLE_VERSION_KEY = "version";
    public static final String VERSIONING_KEY = "versions";
    private static final Pattern keyValP = Pattern.compile("([^=:]*)[=:](.*)");
    private static final Pattern leftTrimP = Pattern.compile("^[ '\"]*");
    private static final Pattern rightTrimP = Pattern.compile("[ '\"]*$");
    public static final Map<String, Map<String, Long>> decodedVersionMaps = new LimitedHashMap<String, Map<String, Long>>(100);

    public static InheritanceProject resolve(String name) {
        return InheritanceProject.getProjectByName(name);
    }

    public static Map<InheritanceProject, Long> resolve(Map<String, Long> in) {
        if (in == null) {
            return Collections.emptyMap();
        }
        HashMap<InheritanceProject, Long> out = new HashMap<InheritanceProject, Long>();
        for (Map.Entry<String, Long> entry : in.entrySet()) {
            InheritanceProject ip = VersionHandler.resolve(entry.getKey());
            if (ip == null) continue;
            out.put(ip, entry.getValue());
        }
        return out;
    }

    public static Map<String, Long> getVersions() {
        Map<String, Long> map = VersionHandler.getFromRequest();
        if (!map.isEmpty()) {
            return map;
        }
        map = VersionHandler.getFromThread();
        if (!map.isEmpty()) {
            return map;
        }
        return Collections.emptyMap();
    }

    public static Long getVersion(InheritanceProject root) {
        Map<String, Long> map = VersionHandler.getVersions();
        Long v = map.get(root.getFullName());
        if (v == null) {
            return root.getStableVersion();
        }
        return v;
    }

    public static Map<String, Long> initVersions(AbstractProject<?, ?> root) {
        Map<String, Long> envMap = VersionHandler.getVersions();
        VersionHandler.setVersions(envMap);
        Map<String, Long> jobMap = VersionHandler.getFromProject(root);
        HashMap<String, Long> join = new HashMap<String, Long>();
        if (jobMap != null && !jobMap.isEmpty()) {
            join.putAll(jobMap);
        }
        if (envMap != null && !envMap.isEmpty()) {
            join.putAll(envMap);
        }
        VersionHandler.setVersions(join);
        return join;
    }

    public static Map<String, Long> initVersions(Map<String, Long> map) {
        VersionHandler.setVersions(map);
        return map;
    }

    public static Map<String, Long> addVersions(Map<String, Long> map) {
        HashMap<String, Long> join = new HashMap<String, Long>();
        join.putAll(VersionHandler.getVersions());
        join.putAll(map);
        VersionHandler.setVersions(join);
        return join;
    }

    private static void setVersions(Map<String, Long> map) {
        VersionHandler.setInRequest(map);
        VersionHandler.setInThread(map);
    }

    public static void clearVersions() {
        VersionHandler.clearInRequest();
        VersionHandler.clearInThread();
    }

    public static void clearVersionsPartial() {
        VersionHandler.clearInThread();
    }

    public static Map<String, Long> getFromProject(AbstractProject<?, ?> root) {
        if (root == null || !(root instanceof InheritanceProject)) {
            return Collections.emptyMap();
        }
        InheritanceProject ip = (InheritanceProject)root;
        List<InheritanceProject.InheritedVersionInfo> versions = ip.getAllInheritedVersionsList();
        if (versions == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (InheritanceProject.InheritedVersionInfo v : versions) {
            map.put(v.project.getFullName(), v.version);
        }
        return map;
    }

    public static Map<String, Long> getFromUrlParameter() {
        InheritanceProject ip;
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> out = new HashMap<String, Long>();
        String param = req.getParameter(VERSIONING_KEY);
        if (param != null && !param.isEmpty()) {
            out.putAll(VersionHandler.decodeUrlParameter(param));
        }
        if ((param = req.getParameter(SINGLE_VERSION_KEY)) != null && !param.isEmpty() && (ip = InheritanceProject.getProjectFromRequest(req)) != null) {
            try {
                out.put(ip.getFullName(), Long.valueOf(param));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return out.isEmpty() ? Collections.emptyMap() : out;
    }

    public static String getFullUrlParameter(Map<String, Long> vMap) {
        String value = VersionHandler.encodeUrlParameter(vMap);
        return VersionHandler.getFullUrlParameter(value);
    }

    public static String getFullUrlParameter(String value) {
        String verUrlParm = String.format("%s=\"%s\"", VERSIONING_KEY, value);
        return verUrlParm;
    }

    public static String encodeUrlParameter(InheritanceProject root) {
        Map<String, Long> map = VersionHandler.getFromProject(root);
        return VersionHandler.encodeUrlParameter(map);
    }

    public static String encodeUrlParameter(Map<String, Long> in) {
        if (in == null || in.isEmpty()) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        for (Map.Entry<String, Long> e : in.entrySet()) {
            String key = e.getKey();
            if (key == null || key.isEmpty()) continue;
            out.append(e.getKey());
            out.append("=");
            out.append(e.getValue());
            out.append(";");
        }
        if (out.length() > 0) {
            out.deleteCharAt(out.length() - 1);
        }
        String raw = out.toString();
        decodedVersionMaps.put(raw, in);
        return raw;
    }

    public static Map<String, Long> decodeUrlParameter(String in) {
        if (in == null || in.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Long> out = decodedVersionMaps.get(in);
        if (out != null) {
            decodedVersionMaps.put(in, out);
            return out;
        }
        out = new HashMap<String, Long>();
        String escaped = in;
        String unescaped = in;
        do {
            unescaped = escaped;
            try {
                escaped = URLDecoder.decode(unescaped, "utf8");
            }
            catch (UnsupportedEncodingException ex) {
                escaped = unescaped;
                break;
            }
        } while (!unescaped.equals(escaped));
        String inMod = escaped.trim();
        inMod = leftTrimP.matcher(inMod).replaceFirst("");
        inMod = rightTrimP.matcher(inMod).replaceFirst("");
        for (String entry : inMod.split(";")) {
            Matcher m = keyValP.matcher(entry);
            while (m.find()) {
                String value;
                String key = m.group(1);
                if (key == null || key.isEmpty() || (value = m.group(2)) == null || value.isEmpty()) continue;
                try {
                    Long lv = Long.parseLong(value);
                    out.put(key, lv);
                }
                catch (NumberFormatException ex) {}
            }
        }
        decodedVersionMaps.put(in, out);
        return out;
    }

    public static Map<String, Long> getFromRequest() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req == null) {
            return Collections.emptyMap();
        }
        Map<String, Long> versionMap = VersionHandler.getFromUrlParameter();
        if (!versionMap.isEmpty()) {
            return versionMap;
        }
        Object verObj = req.getAttribute(VERSIONING_KEY);
        if (verObj == null) {
            if (StringUtils.isEmpty((String)req.getParameter("project")) || StringUtils.isEmpty((String)req.getParameter(SINGLE_VERSION_KEY))) {
                return Collections.emptyMap();
            }
            return VersionHandler.getFromFormRequest(req);
        }
        try {
            Map verMap = (Map)verObj;
            return verMap;
        }
        catch (ClassCastException ex) {
            log.warning("ClassCaseException when attempting to decode 'versions' attribute of HTTP-Request");
            return Collections.emptyMap();
        }
    }

    private static void setInRequest(Map<String, Long> map) {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req == null) {
            return;
        }
        req.setAttribute(VERSIONING_KEY, map);
    }

    private static void clearInRequest() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req == null) {
            return;
        }
        req.removeAttribute(VERSIONING_KEY);
    }

    private static Map<String, Long> getFromThread() {
        Object verObj = ThreadAssocStore.getInstance().getValue(VERSIONING_KEY);
        if (verObj == null) {
            return Collections.emptyMap();
        }
        try {
            Map verMap = (Map)verObj;
            return verMap;
        }
        catch (ClassCastException ex) {
            log.warning("ClassCaseException when attempting to decode 'versions' attribute of ThreadAssocStore");
            return Collections.emptyMap();
        }
    }

    private static void setInThread(Map<String, Long> map) {
        ThreadAssocStore.getInstance().setValue(VERSIONING_KEY, map);
    }

    private static void clearInThread() {
        ThreadAssocStore.getInstance().clear(VERSIONING_KEY);
    }

    public static Map<String, Long> getFromFormRequest(StaplerRequest req) {
        JSONObject jForm;
        if (req == null) {
            return Collections.emptyMap();
        }
        try {
            jForm = req.getSubmittedForm();
        }
        catch (ServletException e) {
            return Collections.emptyMap();
        }
        if (!jForm.has("project") || !jForm.has(SINGLE_VERSION_KEY)) {
            return Collections.emptyMap();
        }
        String[] projects = null;
        try {
            Object obj = jForm.get("project");
            if (obj instanceof JSONArray) {
                JSONArray a = (JSONArray)obj;
                projects = new String[a.size()];
                for (int i = 0; i < a.size(); ++i) {
                    projects[i] = ((JSONArray)obj).getString(i);
                }
            } else if (obj instanceof String) {
                projects = new String[]{obj.toString()};
            }
        }
        catch (JSONException ex) {
            projects = null;
        }
        Long[] versions = null;
        try {
            Object obj = jForm.get(SINGLE_VERSION_KEY);
            if (obj instanceof JSONArray) {
                JSONArray a = (JSONArray)obj;
                versions = new Long[a.size()];
                for (int i = 0; i < a.size(); ++i) {
                    versions[i] = ((JSONArray)obj).getLong(i);
                }
            } else if (obj instanceof String) {
                versions = new Long[]{Long.valueOf(obj.toString())};
            }
        }
        catch (JSONException ex) {
            versions = null;
        }
        catch (NumberFormatException ex) {
            versions = null;
        }
        if (projects == null || versions == null || versions.length != projects.length) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> verMap = new HashMap<String, Long>();
        for (int i = 0; i < projects.length; ++i) {
            verMap.put(projects[i], versions[i]);
        }
        return verMap;
    }
}

