/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.references;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.DescriptorExtensionList;
import hudson.RelativePath;
import hudson.init.TermMilestone;
import hudson.init.Terminator;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Project;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.references.filters.IProjectReferenceFilter;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=3)
public abstract class AbstractProjectReference
implements Describable<AbstractProjectReference> {
    protected String name;
    private static final Cache<String, InheritanceProject> nameLookup = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).weakValues().build();

    @Terminator(before=TermMilestone.COMPLETED)
    public static void onJenkinsStop() {
        nameLookup.invalidateAll();
        nameLookup.cleanUp();
    }

    public AbstractProjectReference(String targetJob) {
        this.name = targetJob;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[");
        b.append(this.name);
        b.append("]");
        return b.toString();
    }

    public InheritanceProject getProject() {
        InheritanceProject ip = (InheritanceProject)nameLookup.getIfPresent((Object)this.name);
        if (ip == null && (ip = InheritanceProject.getProjectByName(this.name)) != null) {
            nameLookup.put((Object)this.name, (Object)ip);
        }
        return ip;
    }

    public String getName() {
        return this.name;
    }

    public void switchProject(InheritanceProject project) {
        if (project != null) {
            this.name = project.getFullName();
        }
    }

    public void switchProject(String name) {
        this.name = name;
    }

    public static DescriptorExtensionList<AbstractProjectReference, ProjectReferenceDescriptor> all() {
        return Jenkins.getInstance().getDescriptorList(AbstractProjectReference.class);
    }

    public static DescriptorExtensionList<AbstractProjectReference, ProjectReferenceDescriptor> all(Class<AbstractProjectReference> clazz) {
        Jenkins j;
        DescriptorExtensionList ret;
        if (clazz == null) {
            clazz = AbstractProjectReference.class;
        }
        if (!(ret = (j = Jenkins.get()).getDescriptorList(clazz)).isEmpty()) {
            return ret;
        }
        DescriptorExtensionList dList = j.getDescriptorList(AbstractProjectReference.class);
        Descriptor clazzDesc = j.getDescriptor(clazz);
        if (clazzDesc == null) {
            return dList;
        }
        for (ProjectReferenceDescriptor prd : dList) {
            if (!clazzDesc.getClass().isAssignableFrom(((Object)((Object)prd)).getClass())) continue;
            ret.add((Descriptor)prd);
        }
        return ret;
    }

    public static List<ProjectReferenceDescriptor> all(String classNameExp) {
        Pattern p = Pattern.compile(classNameExp);
        DescriptorExtensionList<AbstractProjectReference, ProjectReferenceDescriptor> all = AbstractProjectReference.all();
        LinkedList<ProjectReferenceDescriptor> reduced = new LinkedList<ProjectReferenceDescriptor>();
        ListIterator iter = all.listIterator();
        while (iter.hasNext()) {
            ProjectReferenceDescriptor d = (ProjectReferenceDescriptor)((Object)iter.next());
            Matcher mFull = p.matcher(d.clazz.getName());
            Matcher mPart = p.matcher(d.clazz.getSimpleName());
            if (!mFull.matches() && !mPart.matches()) continue;
            reduced.add(d);
        }
        return reduced;
    }

    public static ProjectReferenceDescriptor getDescriptor(Class<? extends AbstractProjectReference> clazz) {
        return (ProjectReferenceDescriptor)Jenkins.get().getDescriptorOrDie(clazz);
    }

    public ProjectReferenceDescriptor getDescriptor() {
        return (ProjectReferenceDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    public static abstract class ProjectReferenceDescriptor
    extends Descriptor<AbstractProjectReference> {
        protected final Cache<String, IProjectReferenceFilter> filters = CacheBuilder.newBuilder().concurrencyLevel(4).expireAfterAccess(30L, TimeUnit.SECONDS).expireAfterWrite(1L, TimeUnit.MINUTES).build();

        protected ProjectReferenceDescriptor(Class<? extends AbstractProjectReference> klazz) {
            super(klazz);
        }

        protected ProjectReferenceDescriptor() {
        }

        public String getValuePage() {
            return this.getViewPage(this.clazz, "index.jelly");
        }

        public FormValidation doCheckName(@QueryParameter String targetJob, @RelativePath(value="..") @QueryParameter String parents, @AncestorInPath InheritanceProject localJob) {
            if (targetJob == null || targetJob.isEmpty()) {
                return FormValidation.error((String)"You need to pass a valid project name");
            }
            if (localJob == null) {
                return FormValidation.ok();
            }
            InheritanceProject targetProject = InheritanceProject.getProjectByName(targetJob);
            if (targetProject == null) {
                return FormValidation.error((String)"Project name can't be resolved to project of correct type");
            }
            if (targetProject == localJob) {
                return FormValidation.error((String)"Project should not reference itself");
            }
            String[] pNames = parents != null ? StringUtils.split((String)parents, (String)",") : new String[]{};
            for (int i = 0; i < pNames.length; ++i) {
                pNames[i] = pNames[i].trim();
            }
            boolean hasCycle = localJob.hasCyclicDependency(false, pNames);
            if (hasCycle) {
                return FormValidation.error((String)"Adding this project would cause a cyclic/diamond dependency.");
            }
            return FormValidation.ok();
        }

        public ListBoxModel internalFillNameItems(String targetJob, IProjectReferenceFilter filter) {
            TreeSet<String> projNames = new TreeSet<String>();
            for (InheritanceProject ip : InheritanceProject.getProjectsMap().values()) {
                if (!this.projectIsCompatible(ip) || filter != null && !filter.isApplicable(ip)) continue;
                projNames.add(ip.getFullName());
            }
            if (targetJob != null) {
                projNames.add(targetJob);
            }
            ListBoxModel model = new ListBoxModel();
            for (String pName : projNames) {
                model.add(pName, pName);
            }
            return model;
        }

        public ListBoxModel doFillNameItems(@QueryParameter String targetJob, @QueryParameter String filterKey) {
            IProjectReferenceFilter filter = filterKey != null && !filterKey.isEmpty() ? (IProjectReferenceFilter)this.filters.getIfPresent((Object)filterKey) : null;
            return this.internalFillNameItems(targetJob, filter);
        }

        public boolean projectIsCompatible(Project p) {
            Job currJob;
            if (!(p instanceof InheritanceProject)) {
                return false;
            }
            InheritanceProject ip = (InheritanceProject)p;
            if (ip.getIsTransient()) {
                return false;
            }
            StaplerRequest req = Stapler.getCurrentRequest();
            return req == null || (currJob = (Job)req.findAncestorObject(Job.class)) == null || currJob.getClass() == ip.getClass();
        }

        public void addReferenceFilter(String key, IProjectReferenceFilter filter) {
            if (key == null || key.isEmpty() || filter == null) {
                return;
            }
            this.filters.put((Object)key, (Object)filter);
        }
    }
}

