/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.parameters;

import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.inheritance.ParameterSelector;
import hudson.plugins.project_inheritance.projects.parameters.InheritableStringParameterReferenceDefinition;
import hudson.plugins.project_inheritance.projects.parameters.Messages;
import hudson.plugins.project_inheritance.projects.references.AbstractProjectReference;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class InheritableStringParameterDefinition
extends StringParameterDefinition {
    private static final long serialVersionUID = 5458085487475338803L;
    private final IModes inheritanceMode;
    private final boolean mustHaveDefaultValue;
    private final boolean mustBeAssigned;
    private final boolean isHidden;
    private final WhitespaceMode whitespaceMode;
    public transient String variance = null;

    public InheritableStringParameterDefinition(String name, String defaultValue) {
        this(name, defaultValue, null, IModes.OVERWRITABLE, false, false, WhitespaceMode.ADD_IF_EXTENSION, false);
    }

    public InheritableStringParameterDefinition(String name, String defaultValue, IModes iMode, boolean mustHaveDefaultValue, boolean mustBeAssigned, WhitespaceMode whitespaceMode, boolean isHidden) {
        this(name, defaultValue, null, iMode, mustHaveDefaultValue, mustBeAssigned, whitespaceMode, isHidden);
    }

    public InheritableStringParameterDefinition(String name, String defaultValue, String description, IModes inheritanceMode, boolean mustHaveDefaultValue, boolean mustBeAssigned, WhitespaceMode whitespaceMode, boolean isHidden) {
        super(StringUtils.trim((String)name), defaultValue, description);
        this.mustHaveDefaultValue = mustHaveDefaultValue;
        this.mustBeAssigned = mustBeAssigned;
        this.isHidden = isHidden;
        this.whitespaceMode = whitespaceMode == null ? WhitespaceMode.KEEP : whitespaceMode;
        this.inheritanceMode = inheritanceMode == null ? IModes.OVERWRITABLE : inheritanceMode;
    }

    @DataBoundConstructor
    public InheritableStringParameterDefinition(String name, String defaultValue, String description, String inheritanceMode, boolean mustHaveDefaultValue, boolean mustBeAssigned, String whitespaceMode, boolean isHidden) {
        this(StringUtils.trim((String)name), defaultValue, description, StringUtils.isBlank((String)inheritanceMode) ? IModes.OVERWRITABLE : IModes.valueOf(inheritanceMode), mustHaveDefaultValue, mustBeAssigned, StringUtils.isBlank((String)whitespaceMode) ? WhitespaceMode.KEEP : WhitespaceMode.valueOf(whitespaceMode), isHidden);
    }

    public InheritableStringParameterDefinition(InheritableStringParameterDefinition other) {
        this(other.getName(), other.getDefaultValue(), other.getDescription(), other.getInheritanceModeAsVar(), other.getMustHaveDefaultValue(), other.getMustBeAssigned(), other.getWhitespaceModeAsVar(), other.getIsHidden());
        this.variance = other.variance;
    }

    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (!(defaultValue instanceof StringParameterValue)) {
            return super.copyWithDefaultValue(defaultValue);
        }
        StringParameterValue spv = (StringParameterValue)defaultValue;
        String value = spv.getValue().toString();
        InheritableStringParameterDefinition ispd = new InheritableStringParameterDefinition(this.getName(), value, this.getDescription(), this.getInheritanceModeAsVar(), this.getMustHaveDefaultValue(), this.getMustBeAssigned(), this.getWhitespaceModeAsVar(), this.getIsHidden());
        ispd.variance = this.variance;
        return ispd;
    }

    public String toString() {
        return String.format("[%s]", this.getName());
    }

    public String getLocationString(InheritanceProject root) {
        StringBuilder b = new StringBuilder();
        ParameterSelector pSel = ParameterSelector.instance;
        List<ParameterSelector.ScopeEntry> fullScope = pSel.getScopedParameterDefinition(root, this.getName());
        boolean first = true;
        for (ParameterSelector.ScopeEntry scope : fullScope) {
            if (!StringUtils.equals((String)scope.param.getName(), (String)this.getName())) continue;
            if (!first) {
                b.append('\u2192');
            } else {
                first = false;
            }
            b.append(scope.owner);
        }
        if (this.variance != null) {
            b.append("; variance: '");
            b.append(this.variance);
            b.append("'");
        }
        return b.toString();
    }

    public String getLocationStringViaStapler() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req == null) {
            return "";
        }
        InheritanceProject root = (InheritanceProject)req.findAncestorObject(InheritanceProject.class);
        if (root == null) {
            return "";
        }
        return this.getLocationString(root);
    }

    public boolean getMustHaveDefaultValue() {
        return this.mustHaveDefaultValue;
    }

    public boolean getMustBeAssigned() {
        return this.mustBeAssigned;
    }

    public String getInheritanceMode() {
        return this.getInheritanceModeAsVar().name();
    }

    public IModes getInheritanceModeAsVar() {
        if (this.inheritanceMode == null) {
            return IModes.OVERWRITABLE;
        }
        return this.inheritanceMode;
    }

    public boolean getIsHidden() {
        return this.isHidden;
    }

    public String getWhitespaceMode() {
        WhitespaceMode m = this.getWhitespaceModeAsVar();
        return m.name();
    }

    public WhitespaceMode getWhitespaceModeAsVar() {
        if (this.whitespaceMode == null) {
            return WhitespaceMode.KEEP;
        }
        return this.whitespaceMode;
    }

    public InheritableStringParameterDefinition getMergeWithOther(ParameterDefinition past) {
        String newDesc;
        WhitespaceMode newWhitespaceMode;
        IModes newInheritanceMode;
        boolean newIsHidden;
        boolean newMustBeAssigned;
        boolean newMustHaveDefaultValue;
        String newVal;
        if (!(past instanceof InheritableStringParameterDefinition)) {
            return this;
        }
        InheritableStringParameterDefinition iPast = (InheritableStringParameterDefinition)past;
        switch (iPast.getInheritanceModeAsVar()) {
            case OVERWRITABLE: {
                newVal = this.getDefaultValue();
                break;
            }
            case FIXED: {
                newVal = iPast.getDefaultValue();
                break;
            }
            case EXTENSIBLE: {
                StringBuilder v = new StringBuilder(iPast.getDefaultValue());
                if (iPast.getWhitespaceModeAsVar() == WhitespaceMode.ADD_IF_EXTENSION) {
                    v.append(" ");
                }
                v.append(this.getDefaultValue());
                newVal = v.toString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode: " + (Object)((Object)iPast.getInheritanceModeAsVar()));
            }
        }
        if (this instanceof InheritableStringParameterReferenceDefinition) {
            newMustHaveDefaultValue = iPast.getMustHaveDefaultValue();
            newMustBeAssigned = iPast.getMustBeAssigned();
            newIsHidden = iPast.getIsHidden();
            newInheritanceMode = iPast.getInheritanceModeAsVar();
            newWhitespaceMode = iPast.getWhitespaceModeAsVar();
            newDesc = iPast.getDescription();
        } else {
            newMustHaveDefaultValue = this.getMustHaveDefaultValue() || iPast.getMustHaveDefaultValue();
            newMustBeAssigned = this.getMustBeAssigned() || iPast.getMustBeAssigned();
            newIsHidden = this.getIsHidden() || iPast.getIsHidden();
            newInheritanceMode = this.getInheritanceModeAsVar();
            newWhitespaceMode = this.getWhitespaceModeAsVar();
            newDesc = StringUtils.isNotBlank((String)this.getDescription()) ? this.getDescription() : iPast.getDescription();
        }
        return new InheritableStringParameterDefinition(this.getName(), newVal, newDesc, newInheritanceMode, newMustHaveDefaultValue, newMustBeAssigned, newWhitespaceMode, newIsHidden);
    }

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        String nextVal;
        String val;
        ParameterValue pv = super.createValue(req, jo);
        if (pv instanceof StringParameterValue && (val = ((StringParameterValue)pv).getValue().toString()) != (nextVal = this.trimValue(val))) {
            return new StringParameterValue(pv.getName(), nextVal);
        }
        return pv;
    }

    public ParameterValue createValue(String value) {
        return new StringParameterValue(this.getName(), this.trimValue(value));
    }

    private String trimValue(String value) {
        if (value == null) {
            return "";
        }
        if (this.whitespaceMode == WhitespaceMode.TRIM) {
            String nextVal = StringUtils.stripToEmpty((String)value);
            if (value.length() != nextVal.length()) {
                return nextVal;
            }
        }
        return value;
    }

    public StringParameterValue getDefaultParameterValue() {
        return new StringParameterValue(this.getName(), this.trimValue(this.getDefaultValue()), this.getDescription());
    }

    @Extension
    public static class DescriptorImpl
    extends StringParameterDefinition.DescriptorImpl {
        public String getDisplayName() {
            return Messages.InheritableStringParameterDefinition_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/project-inheritance/help/parameter/inheritableString.html";
        }

        public FormValidation doCheckName(@QueryParameter String name, @AncestorInPath InheritanceProject project) {
            if (project == null) {
                return FormValidation.ok();
            }
            FormValidation fv = FormValidation.ok();
            Set<InheritanceProject> references = this.getReferencedProjects(project);
            for (InheritanceProject proj : references) {
                ParameterSelector pSel = ParameterSelector.instance;
                List<ParameterSelector.ScopeEntry> scope = pSel.getScopedParameterDefinition(project, name);
                if (scope == null) continue;
                for (ParameterSelector.ScopeEntry entry : scope) {
                    String msg;
                    if (entry.param == null || !(entry.param instanceof InheritableStringParameterDefinition) || !entry.param.getName().equals(name) || entry.owner.equals(project.getFullName())) continue;
                    InheritableStringParameterDefinition ispd = (InheritableStringParameterDefinition)entry.param;
                    IModes mode = ispd.getInheritanceModeAsVar();
                    if (mode == IModes.FIXED) {
                        if (proj != project) {
                            msg = String.format("Be careful! This variable is marked as fixed in the compatible job: %s", proj.getFullName());
                            fv = FormValidation.warning((String)msg);
                        } else {
                            msg = String.format("You may not override a parameter marked as fixed in the parent: %s.", entry.owner);
                            fv = FormValidation.error((String)msg);
                        }
                        return fv;
                    }
                    msg = String.format("FYI: You are redefining a parameter that is marked as '%s'%s%s and was defined in the %s: %s.", mode.toString(), ispd.getMustBeAssigned() ? ", must be assigned before run" : "", ispd.getMustHaveDefaultValue() ? ",  must have a default set" : "", proj == project ? "parent" : "compatible job", entry.owner);
                    fv = FormValidation.ok((String)msg);
                }
            }
            return fv;
        }

        public FormValidation doCheckDefaultValue(@QueryParameter String name) {
            return FormValidation.ok();
        }

        public ListBoxModel doFillInheritanceModeItems() {
            ListBoxModel m = new ListBoxModel();
            for (IModes im : IModes.values()) {
                m.add(im.toString(), im.name());
            }
            return m;
        }

        public ListBoxModel doFillWhitespaceModeItems() {
            ListBoxModel m = new ListBoxModel();
            for (WhitespaceMode mode : WhitespaceMode.values()) {
                m.add(mode.toString(), mode.name());
            }
            return m;
        }

        protected Set<InheritanceProject> getReferencedProjects(InheritanceProject root) {
            if (root == null) {
                return Collections.emptySet();
            }
            HashSet<InheritanceProject> refs = new HashSet<InheritanceProject>();
            refs.add(root);
            for (AbstractProjectReference apr : root.getCompatibleProjects()) {
                InheritanceProject mate = apr.getProject();
                if (mate == null) continue;
                refs.add(mate);
            }
            return refs;
        }
    }

    public static enum WhitespaceMode {
        TRIM,
        KEEP,
        ADD_IF_EXTENSION;


        public String toString() {
            switch (this) {
                case KEEP: {
                    return Messages.WhitespaceMode_KEEP();
                }
                case TRIM: {
                    return Messages.WhitespaceMode_TRIM();
                }
                case ADD_IF_EXTENSION: {
                    return Messages.WhitespaceMode_ADD();
                }
            }
            return this.name();
        }
    }

    public static enum IModes {
        OVERWRITABLE,
        EXTENSIBLE,
        FIXED;

        private static final String[] names;

        private static String[] getNames() {
            String[] n = new String[IModes.values().length];
            n[IModes.FIXED.ordinal()] = "Fixed";
            n[IModes.EXTENSIBLE.ordinal()] = "Extensible";
            n[IModes.OVERWRITABLE.ordinal()] = "Overwritable";
            return n;
        }

        public static IModes getFromName(String name) {
            for (int i = 0; i < names.length; ++i) {
                if (!name.equals(names[i])) continue;
                return IModes.values()[i];
            }
            return null;
        }

        public String toString() {
            return names[this.ordinal()];
        }

        public boolean isFixed() {
            return this == FIXED;
        }

        static {
            names = IModes.getNames();
        }
    }
}

