/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.inheritance;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.inheritance.InheritanceSelector;
import hudson.plugins.project_inheritance.projects.parameters.InheritableStringParameterDefinition;
import hudson.plugins.project_inheritance.projects.parameters.InheritanceParametersDefinitionProperty;
import hudson.plugins.project_inheritance.projects.references.AbstractProjectReference;
import hudson.plugins.project_inheritance.projects.references.ProjectReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class ParameterSelector
extends InheritanceSelector<JobProperty<?>> {
    private static final long serialVersionUID = 6765147898181407182L;
    public static final String VERSION_PARAM_NAME = "JENKINS_JOB_VERSIONS";
    @Extension
    public static final ParameterSelector instance = new ParameterSelector();

    @Override
    public boolean isApplicableFor(Class<?> clazz) {
        return JobProperty.class.isAssignableFrom(clazz);
    }

    @Override
    public InheritanceSelector.MODE getModeFor(Class<?> clazz) {
        if (ParametersDefinitionProperty.class.isAssignableFrom(clazz)) {
            return InheritanceSelector.MODE.MERGE;
        }
        return InheritanceSelector.MODE.NOT_RESPONSIBLE;
    }

    @Override
    public String getObjectIdentifier(JobProperty<?> obj) {
        if (obj instanceof ParametersDefinitionProperty) {
            return "SINGLETON";
        }
        return null;
    }

    @Override
    public JobProperty<?> merge(JobProperty<?> prior, JobProperty<?> latter, InheritanceProject caller) {
        if (!(prior instanceof ParametersDefinitionProperty) || !(latter instanceof ParametersDefinitionProperty)) {
            return latter;
        }
        return this.createMerged((ParametersDefinitionProperty)prior, (ParametersDefinitionProperty)latter);
    }

    private ParametersDefinitionProperty createMerged(ParametersDefinitionProperty prior, ParametersDefinitionProperty latter) {
        ParametersDefinitionProperty[] pdps = new ParametersDefinitionProperty[]{latter, prior};
        TreeMap<String, Object> unifyMap = new TreeMap<String, Object>();
        for (int i = pdps.length - 1; i >= 0; --i) {
            ParametersDefinitionProperty pdp = pdps[i];
            for (ParameterDefinition pd : pdp.getParameterDefinitions()) {
                ParameterDefinition past = (ParameterDefinition)unifyMap.get(pd.getName());
                if (past == null) {
                    unifyMap.put(pd.getName(), pd);
                    continue;
                }
                if (pd instanceof InheritableStringParameterDefinition) {
                    InheritableStringParameterDefinition ispd = (InheritableStringParameterDefinition)pd;
                    unifyMap.put(pd.getName(), (Object)ispd.getMergeWithOther(past));
                    continue;
                }
                unifyMap.put(pd.getName(), pd);
            }
        }
        ArrayList<ParameterDefinition> unifyList = new ArrayList<ParameterDefinition>(unifyMap.values());
        InheritanceParametersDefinitionProperty ret = new InheritanceParametersDefinitionProperty(latter.getOwner(), unifyList);
        return ret;
    }

    @Override
    public JobProperty<?> handleSingleton(JobProperty<?> jp, InheritanceProject caller) {
        if (!(jp instanceof ParametersDefinitionProperty)) {
            return jp;
        }
        ParametersDefinitionProperty pdp = (ParametersDefinitionProperty)jp;
        if (pdp.getOwner() == caller && pdp instanceof InheritanceParametersDefinitionProperty) {
            return jp;
        }
        return new InheritanceParametersDefinitionProperty((AbstractProject<?, ?>)caller, pdp.getParameterDefinitions());
    }

    public List<ScopeEntry> getAllScopedParameterDefinitions(InheritanceProject root) {
        LinkedList<ScopeEntry> lst = new LinkedList<ScopeEntry>();
        for (AbstractProjectReference ref : root.getAllParentReferences(ProjectReference.PrioComparator.SELECTOR.PARAMETER, true)) {
            ParametersDefinitionProperty parPDP;
            InheritanceProject par = ref.getProject();
            if (par == null || (parPDP = par.getProperty(ParametersDefinitionProperty.class, InheritanceProject.IMode.LOCAL_ONLY)) == null) continue;
            for (ParameterDefinition pd : parPDP.getParameterDefinitions()) {
                lst.add(new ScopeEntry(par.getFullName(), pd));
            }
        }
        ParametersDefinitionProperty variance = root.getVarianceParameters();
        if (variance != null) {
            for (ParameterDefinition pd : variance.getParameterDefinitions()) {
                lst.add(new ScopeEntry(root.getFullName(), pd));
            }
        }
        return lst;
    }

    public List<ScopeEntry> getScopedParameterDefinition(InheritanceProject root, String name) {
        List<ScopeEntry> all = this.getAllScopedParameterDefinitions(root);
        LinkedList<ScopeEntry> out = new LinkedList<ScopeEntry>();
        for (ScopeEntry se : all) {
            String sName = se.param.getName();
            if (!StringUtils.equals((String)sName, (String)name)) continue;
            out.add(se);
        }
        return out;
    }

    public static class ScopeEntry {
        public final String owner;
        public final ParameterDefinition param;

        public ScopeEntry(String owner, ParameterDefinition param) {
            this.owner = owner;
            this.param = param;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append('[');
            b.append(this.owner);
            b.append(", ");
            b.append(this.param.toString());
            b.append(']');
            return b.toString();
        }
    }
}

