/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.structured.map.proxy.util;

import com.google.common.base.CaseFormat;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;

public final class ReflectionUtil {
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";

    private ReflectionUtil() {
    }

    public static Method findGetter(Class<?> cl, String name) {
        return ReflectionUtil.findMethodByName(cl, GET_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, name));
    }

    public static Method findSetter(Class<?> cl, String name) {
        return ReflectionUtil.findMethodByName(cl, SET_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, name));
    }

    public static Method findMethodByName(Class<?> cl, String name) {
        return ReflectionUtil.findMethodByName(cl.getMethods(), cl, name);
    }

    private static Method findMethodByName(Method[] availableMethods, Class<?> cl, String name) {
        ArrayList methods = Lists.newArrayList();
        for (Method method : availableMethods) {
            if (!method.getName().equals(name)) continue;
            methods.add(method);
        }
        if (methods.isEmpty()) {
            throw new IllegalArgumentException(String.format("No method found for %s class and %s name.", cl.getName(), name));
        }
        return (Method)methods.get(0);
    }

    public static <T> Predicate<Method> methodParameterType(final String name, final Class<T> cl) {
        return new Predicate<Method>(){

            public boolean apply(Method input) {
                return input.getName().equals(name) && input.getParameterTypes().length == 1 && input.getParameterTypes()[0].isAssignableFrom(cl);
            }
        };
    }

    public static Object getFieldValue(Object target, Field field) {
        try {
            boolean state = field.isAccessible();
            if (!state) {
                field.setAccessible(true);
            }
            Object ret = field.get(target);
            if (!state) {
                field.setAccessible(false);
            }
            return ret;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("cannot get field value via reflection", e);
        }
    }

    public static Object getFieldValue(Object subject, Iterator<String> pathElements) {
        Method getter;
        Object ret = null;
        if (subject != null && pathElements != null && pathElements.hasNext() && (getter = ReflectionUtil.findGetter(subject.getClass(), pathElements.next())) != null) {
            try {
                ret = getter.invoke(subject, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                String msg = String.format("Can not get field[%s] value on objectClass[%s]", getter.getName(), subject.getClass());
                throw new IllegalArgumentException(msg, e);
            }
            if (pathElements.hasNext() && ret != null) {
                ret = ReflectionUtil.getFieldValue(ret, pathElements);
            }
        }
        return ret;
    }
}

