/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.structured.map.proxy;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import hu.blackbelt.structured.map.proxy.CompositeClassLoader;
import hu.blackbelt.structured.map.proxy.MapHolder;
import hu.blackbelt.structured.map.proxy.util.ReflectionUtil;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapProxy
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(MapProxy.class);
    public static final String SET = "set";
    public static final String GET = "get";
    public static final String IS = "is";
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new ImmutableMap.Builder().put(Boolean.TYPE, Boolean.class).put(Byte.TYPE, Byte.class).put(Character.TYPE, Character.class).put(Double.TYPE, Double.class).put(Float.TYPE, Float.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Short.TYPE, Short.class).put(Void.TYPE, Void.class).build();
    public static final String DEFAULT_ENUM_MAPPING_METHOD = "name";
    private Map<String, ?> original;
    private Map<String, Object> internal;
    private boolean immutable;
    private boolean nullSafeCollection;
    private String identifierField;
    private Class clazz;
    private final String enumMappingMethod;
    private static CacheLoader<Class, Map<String, AttributeInfo>> typeInfoCacheLoader = new CacheLoader<Class, Map<String, AttributeInfo>>(){

        public Map<String, AttributeInfo> load(Class sourceClass) throws Exception {
            ConcurrentHashMap<String, AttributeInfo> targetTypes = new ConcurrentHashMap<String, AttributeInfo>();
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(sourceClass).getPropertyDescriptors()) {
                String attrName = propertyDescriptor.getName();
                Class<?> propertyType = propertyDescriptor.getPropertyType();
                Optional<ParameterizedType> parametrizedType = MapProxy.getGetterOrSetterParameterizedType(propertyDescriptor);
                targetTypes.put(attrName, new AttributeInfo(propertyType, parametrizedType.orElse(null), propertyDescriptor));
            }
            return targetTypes;
        }
    };
    private static LoadingCache<Class, Map<String, AttributeInfo>> typeInfoCache = CacheBuilder.newBuilder().expireAfterAccess(Long.parseLong(System.getProperty("structuredMapProxyCacheExpireInSecond", "60")), TimeUnit.SECONDS).build(typeInfoCacheLoader);
    private Function<Object, Map> objectToMap = o -> {
        if (o instanceof MapHolder) {
            return ((MapHolder)o).toMap();
        }
        if (o instanceof Map) {
            return (Map)o;
        }
        throw new IllegalStateException("Collection element type have to be hu.blackbelt.structured.map.proxy.MapHolder or java.util.Map ");
    };

    public static <T> Builder<T> builder(Class<T> clazz) {
        return new Builder<T>(clazz);
    }

    public static <T> Builder<T> builder(MapProxy proxy) {
        return new Builder(proxy.clazz).withEnumMappingMethod(proxy.enumMappingMethod).withImmutable(proxy.immutable).withNullSafeCollection(proxy.nullSafeCollection).withMap(proxy.original).withIdentifierField(proxy.identifierField);
    }

    private static <T> T newInstance(Class<T> clazz, Map<String, ?> map, boolean immutable, boolean nullSafeCollection, String identifierField, String enumMappingMethod) {
        try {
            return (T)Proxy.newProxyInstance(new CompositeClassLoader(clazz.getClassLoader(), MapHolder.class.getClassLoader()), new Class[]{clazz, MapHolder.class}, (InvocationHandler)new MapProxy(clazz, map, immutable, nullSafeCollection, identifierField, enumMappingMethod));
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException("Could not create instance", e);
        }
    }

    private <T> MapProxy(Class<T> sourceClass, Map<String, ?> map, boolean immutable, boolean nullSafeCollection, String identifierField, String enumMappingMethod) throws IntrospectionException {
        this.original = map;
        this.internal = new HashMap(map);
        this.identifierField = identifierField;
        this.immutable = immutable;
        this.nullSafeCollection = nullSafeCollection;
        this.clazz = sourceClass;
        this.enumMappingMethod = enumMappingMethod;
        Map typeInfo = null;
        try {
            typeInfo = (Map)typeInfoCache.get(sourceClass);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        typeInfo.forEach((attrName, attrInfo) -> {
            if (!this.internal.containsKey(attrName)) return;
            Object value = this.internal.get(attrName);
            if (value instanceof Optional) {
                value = ((Optional)value).orElse(null);
            }
            Class propertyType = attrInfo.getPropertyType();
            Optional<ParameterizedType> parametrizedType = Optional.ofNullable(attrInfo.getParameterType());
            if (value == null) {
                this.internal.put((String)attrName, null);
                return;
            } else if (Collection.class.isAssignableFrom(propertyType)) {
                if (!(value instanceof Collection)) {
                    throw new IllegalArgumentException(String.format("The attribute %s in %s must be collection.", attrName, sourceClass.getName()));
                }
                this.internal.put((String)attrName, this.createCollectionValue((Collection)value, propertyType, parametrizedType.orElse(null), immutable, identifierField, enumMappingMethod));
                return;
            } else if (Optional.class.isAssignableFrom(propertyType) && parametrizedType.isPresent()) {
                Class optionalType = MapProxy.getRawType(parametrizedType.orElseThrow(() -> new IllegalStateException(String.format("Optional type attribute %s in %s class does not have generic type.", attrName, sourceClass.getName()))), 0);
                if (value instanceof Map) {
                    if (!optionalType.isInterface()) throw new IllegalArgumentException(String.format("The attribute %s in %s is Optional. The Optional's generic type have to be interface.", attrName, sourceClass.getName()));
                    this.internal.put((String)attrName, MapProxy.builder(optionalType).withMap((Map)value).withImmutable(immutable).withIdentifierField(identifierField).withEnumMappingMethod(enumMappingMethod).newInstance());
                    return;
                } else if (optionalType.isEnum()) {
                    this.internal.put((String)attrName, this.createEnumValue(value, optionalType));
                    return;
                } else {
                    if (!optionalType.isAssignableFrom(value.getClass())) return;
                    this.internal.put((String)attrName, value);
                }
                return;
            } else if (value instanceof Map) {
                if (Map.class.isAssignableFrom(propertyType)) {
                    this.internal.put((String)attrName, this.createMapValue((Map)value, propertyType, parametrizedType.orElse(null), immutable, identifierField, enumMappingMethod));
                    return;
                } else {
                    if (!propertyType.isInterface()) return;
                    this.internal.put((String)attrName, MapProxy.builder(propertyType).withMap((Map)value).withImmutable(immutable).withIdentifierField(identifierField).withEnumMappingMethod(enumMappingMethod).newInstance());
                }
                return;
            } else if (propertyType.isAssignableFrom(value.getClass())) {
                this.internal.put((String)attrName, value);
                return;
            } else if (propertyType.isEnum()) {
                this.internal.put((String)attrName, this.createEnumValue(value, propertyType));
                return;
            } else {
                this.internal.put((String)attrName, this.getValueAs(value, propertyType, "Could not assign " + value.getClass() + " to " + sourceClass.getName() + "." + attrName + " as %s"));
            }
        });
    }

    private static Optional<ParameterizedType> getGetterOrSetterParameterizedType(PropertyDescriptor propertyDescriptor) {
        Type genericType = null;
        if (propertyDescriptor.getReadMethod() != null) {
            genericType = propertyDescriptor.getReadMethod().getGenericReturnType();
        }
        if (genericType == null && propertyDescriptor.getWriteMethod() != null && propertyDescriptor.getWriteMethod().getGenericParameterTypes().length > 0) {
            genericType = propertyDescriptor.getWriteMethod().getGenericParameterTypes()[0];
        }
        if (genericType != null && genericType instanceof ParameterizedType) {
            return Optional.of((ParameterizedType)genericType);
        }
        return Optional.empty();
    }

    private Object createEnumValue(Object value, Class returnType) {
        Enum enumValue = null;
        if (this.enumMappingMethod.equals(DEFAULT_ENUM_MAPPING_METHOD)) {
            enumValue = (Enum)Enum.valueOf(returnType, (String)value);
        } else {
            for (Object enumConstant : returnType.getEnumConstants()) {
                try {
                    Object enumAttributeValue = returnType.getMethod(this.enumMappingMethod, new Class[0]).invoke(enumConstant, new Object[0]);
                    if (!value.equals(enumAttributeValue)) continue;
                    enumValue = (Enum)enumConstant;
                    break;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    enumValue = null;
                }
            }
            if (enumValue == null) {
                throw new IllegalArgumentException(String.format("Enumeration couldn't be resolved: %s.%s via method %s()", returnType, value, this.enumMappingMethod));
            }
        }
        return enumValue;
    }

    private Map createMapValue(Map value, Class propertyType, ParameterizedType parameterizedType, boolean immutable, String identifierField, String enumMappingMethod) {
        Map<?, ?> transformedValue;
        if (parameterizedType != null) {
            Class mapKeyType = MapProxy.getRawType(parameterizedType, 0);
            Class mapValueType = MapProxy.getRawType(parameterizedType, 1);
            Function<Map.Entry, Object> keyMapper = MapProxy.mapEntryKey();
            Function<Map.Entry, Object> valueMapper = MapProxy.mapEntryValue();
            if (mapKeyType.isInterface()) {
                keyMapper = keyMapper.andThen(this.objectToMap.andThen(MapProxy.objectToMapProxyFunction(mapKeyType, true, identifierField, enumMappingMethod)));
            }
            if (mapValueType.isInterface()) {
                valueMapper = valueMapper.andThen(this.objectToMap.andThen(MapProxy.objectToMapProxyFunction(mapValueType, immutable, identifierField, enumMappingMethod)));
            }
            transformedValue = value.entrySet().stream().collect(Collectors.toMap(keyMapper, valueMapper));
            if (!immutable) {
                transformedValue = new HashMap(transformedValue);
            }
        } else {
            transformedValue = value;
        }
        return transformedValue;
    }

    private Collection createCollectionValue(Collection value, Class propertyType, ParameterizedType parameterizedType, boolean immutable, String identifierField, String enumMappingMethod) {
        Class collectionType;
        Collection transformedValue = value;
        if (parameterizedType != null && (collectionType = MapProxy.getRawType(parameterizedType, 0)).isInterface() && !Map.class.isAssignableFrom(collectionType)) {
            transformedValue = (Collection)value.stream().map(this.objectToMap).map(MapProxy.objectToMapProxyFunction(collectionType, immutable, identifierField, enumMappingMethod)).collect(MapProxy.toCollectorForType(propertyType));
            if (!immutable) {
                transformedValue = this.createMutableCollection(propertyType, transformedValue);
            }
        }
        return transformedValue;
    }

    private Collection createMutableCollection(Class returnType, Collection valueTransformed) {
        if (valueTransformed == null) {
            return null;
        }
        try {
            Constructor constructor = returnType.getConstructor(new Class[0]);
            valueTransformed = (Collection)constructor.newInstance(new Object[0]);
            valueTransformed.addAll(valueTransformed);
        }
        catch (Exception ex) {
            valueTransformed = List.class.isAssignableFrom(returnType) ? new ArrayList(valueTransformed) : (Set.class.isAssignableFrom(returnType) ? new HashSet(valueTransformed) : new ArrayList(valueTransformed));
        }
        return valueTransformed;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if ("hashCode".equals(m.getName())) {
            return proxy.toString().hashCode();
        }
        if ("equals".equals(m.getName())) {
            Object obj = args[0];
            if (obj == null) {
                return false;
            }
            if (obj.getClass().isAssignableFrom(this.clazz) || this.clazz.isAssignableFrom(obj.getClass())) {
                if (this.identifierField == null) {
                    return obj.toString().equals(proxy.toString());
                }
                Method getId = ReflectionUtil.findGetter(obj.getClass(), this.identifierField);
                Object thisId = this.internal.get(this.identifierField);
                Object thatId = getId.invoke(obj, new Object[0]);
                return thisId != null && thisId.equals(thatId);
            }
            return false;
        }
        if (!SET.equals(m.getName()) && m.getName().startsWith(SET)) {
            if (this.immutable) {
                throw new IllegalStateException("Could not call set on immutable object");
            }
            String attrName = Character.toLowerCase(m.getName().charAt(3)) + m.getName().substring(4);
            Object value = args[0];
            this.internal.put(attrName, value);
        } else {
            if (!GET.equals(m.getName()) && m.getName().startsWith(GET)) {
                AttributeInfo attributeInfo;
                String attrName = Character.toLowerCase(m.getName().charAt(3)) + m.getName().substring(4);
                List value = this.internal.get(attrName);
                if (this.nullSafeCollection && value == null && Collection.class.isAssignableFrom(m.getReturnType())) {
                    value = this.immutable ? Collections.EMPTY_LIST : new ArrayList();
                }
                if ((attributeInfo = (AttributeInfo)((Map)typeInfoCache.get((Object)this.clazz)).get(attrName)) != null && Optional.class.isAssignableFrom(attributeInfo.getPropertyType())) {
                    if (value instanceof Optional) {
                        return value;
                    }
                    return Optional.ofNullable(this.getValueAs(value, MapProxy.getRawType(attributeInfo.getParameterType(), 0), "Unable to get " + attrName + " attribute as %s"));
                }
                return this.getValueAs(value, m.getReturnType(), "Unable to get " + attrName + " attribute as %s");
            }
            if (!IS.equals(m.getName()) && m.getName().startsWith(IS)) {
                String attrName = Character.toLowerCase(m.getName().charAt(2)) + m.getName().substring(3);
                Object value = this.internal.get(attrName);
                return this.getValueAs(value, Boolean.TYPE, "Unable to get " + attrName + " attribute as %s");
            }
            if ("toMap".equals(m.getName())) {
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                for (Map.Entry<String, Object> entry : this.internal.entrySet()) {
                    map.put(MapProxy.mapEntryKey().andThen(this.objectToMapFunction()).apply(entry), MapProxy.mapEntryValue().andThen(this.objectToMapFunction()).apply(entry));
                }
                return map;
            }
            if ("getOriginalMap".equals(m.getName())) {
                return this.original;
            }
            if ("toString".equals(m.getName())) {
                LinkedHashMap map = new LinkedHashMap();
                for (Map.Entry entry : this.internal.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList())) {
                    map.put(entry.getKey(), entry.getValue());
                }
                return "PROXY" + map;
            }
        }
        return null;
    }

    private Object getValueAs(Object value, Class clazz, String errorPattern) {
        Class valueClass = value != null ? value.getClass() : Void.class;
        Optional<Class> valuePrimitiveClass = PRIMITIVES_TO_WRAPPERS.entrySet().stream().filter(e -> Objects.equals(valueClass, e.getValue())).map(e -> (Class)e.getKey()).findAny();
        if (value == null || clazz.isAssignableFrom(value.getClass()) || valuePrimitiveClass.isPresent() && clazz.isAssignableFrom(valuePrimitiveClass.get())) {
            return value;
        }
        try {
            clazz.getConstructor(valueClass).newInstance(value);
        }
        catch (Exception ex) {
            log.debug("Constructor not found to convert value");
        }
        if (valuePrimitiveClass.isPresent()) {
            try {
                return clazz.getConstructor(valuePrimitiveClass.get()).newInstance(value);
            }
            catch (Exception ex) {
                log.debug("Constructor not found to convert primitive value");
            }
        }
        try {
            return clazz.getMethod("parse", valueClass).invoke(null, value);
        }
        catch (Exception ex) {
            log.debug("Parse method not found to convert value");
            if (valuePrimitiveClass.isPresent()) {
                try {
                    return clazz.getMethod("parse", valuePrimitiveClass.get()).invoke(null, value);
                }
                catch (Exception ex2) {
                    log.debug("Parse method not found to convert primitive value");
                }
            }
            throw new IllegalStateException(MessageFormat.format(errorPattern, clazz.getName()));
        }
    }

    private static Function objectToMapProxyFunction(Class type, Boolean immutable, String identifierField, String enumMappingMethod) {
        return o -> MapProxy.builder(type).withMap((Map)o).withIdentifierField(identifierField).withImmutable(immutable).withEnumMappingMethod(enumMappingMethod).newInstance();
    }

    private static Collector toCollectorForType(Class<?> type) {
        Collector collector = Set.class.isAssignableFrom(type) ? Collectors.toSet() : Collectors.toList();
        return collector;
    }

    private static Class getRawType(ParameterizedType parameterizedType, int argnum) {
        Type collectionGenericType = parameterizedType.getActualTypeArguments()[argnum];
        if (collectionGenericType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)collectionGenericType).getRawType();
        }
        return (Class)parameterizedType.getActualTypeArguments()[argnum];
    }

    private Function<Object, Object> objectToMapFunction() {
        return o -> {
            if (o instanceof MapHolder) {
                return ((MapHolder)o).toMap();
            }
            if (o instanceof Map) {
                return ((Map)o).entrySet().stream().collect(Collectors.toMap(MapProxy.mapEntryKey().andThen(this.objectToMapFunction()), MapProxy.mapEntryValue().andThen(this.objectToMapFunction())));
            }
            if (o instanceof Collection) {
                return ((Collection)o).stream().map(v -> {
                    if (v instanceof MapHolder) {
                        return ((MapHolder)v).toMap();
                    }
                    return v;
                }).collect(Collectors.toList());
            }
            if (o instanceof Enum) {
                try {
                    return ((Enum)o).getClass().getMethod(this.enumMappingMethod, new Class[0]).invoke(o, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return o;
        };
    }

    private static Function<Map.Entry, ?> mapEntryKey() {
        return Map.Entry::getKey;
    }

    private static Function<Map.Entry, ?> mapEntryValue() {
        return Map.Entry::getValue;
    }

    private static class AttributeInfo {
        Class propertyType;
        ParameterizedType parameterType;
        PropertyDescriptor propertyDescriptor;

        public AttributeInfo(Class propertyType, ParameterizedType parameterType, PropertyDescriptor propertyDescriptor) {
            this.propertyType = propertyType;
            this.parameterType = parameterType;
            this.propertyDescriptor = propertyDescriptor;
        }

        public Class getPropertyType() {
            return this.propertyType;
        }

        public ParameterizedType getParameterType() {
            return this.parameterType;
        }

        public PropertyDescriptor getPropertyDescriptor() {
            return this.propertyDescriptor;
        }
    }

    public static class Builder<T> {
        private final Class<T> clazz;
        private boolean immutable = false;
        private boolean nullSafeCollection = false;
        private Map<String, ?> map = Collections.emptyMap();
        private String identifierField;
        private String enumMappingMethod = "name";

        private Builder(Class<T> clazz) {
            this.clazz = clazz;
        }

        public Builder<T> withImmutable(boolean immutable) {
            this.immutable = immutable;
            return this;
        }

        public Builder<T> withNullSafeCollection(boolean nullSafeCollection) {
            this.nullSafeCollection = nullSafeCollection;
            return this;
        }

        public Builder<T> withIdentifierField(String identifierField) {
            this.identifierField = identifierField;
            return this;
        }

        public Builder<T> withMap(Map<String, ?> map) {
            this.map = map;
            return this;
        }

        public Builder<T> withEnumMappingMethod(String enumMappingMethod) {
            this.enumMappingMethod = enumMappingMethod;
            return this;
        }

        public T newInstance() {
            return MapProxy.newInstance(this.clazz, this.map, this.immutable, this.nullSafeCollection, this.identifierField, this.enumMappingMethod);
        }
    }
}

