/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.structured.map.proxy;

import com.google.common.collect.ImmutableList;
import hu.blackbelt.structured.map.proxy.MapProxy;
import hu.blackbelt.structured.map.proxy.util.ReflectionUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class MapBuilderProxy
implements InvocationHandler {
    Object internal;
    String prefix;

    public static <B, T> Builder<B, T> builder(Class<B> builderClass, Class<T> targetClass) {
        return new Builder<B, T>(builderClass, targetClass);
    }

    public static <B, T> Builder<B, T> builder(Class<B> builderClass, T targetInstance) {
        return new Builder(builderClass, targetInstance.getClass()).withTargetInstance(targetInstance);
    }

    private MapBuilderProxy(Object target, String builderMethodPrefix) {
        this.internal = target;
        this.prefix = builderMethodPrefix;
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.getName().startsWith("build")) {
            return this.internal;
        }
        String attrName = Character.toUpperCase(m.getName().charAt(0)) + m.getName().substring(1);
        if (this.prefix != null && !this.prefix.equals("")) {
            attrName = Character.toUpperCase(m.getName().charAt(this.prefix.length())) + m.getName().substring(this.prefix.length() + 1);
        }
        Method setterMethod = ReflectionUtil.findSetter(this.internal.getClass(), attrName);
        Object[] value = null;
        value = args[0] instanceof Object[] ? new Object[]{ImmutableList.copyOf((Object[])((Object[])args[0]))} : new Object[]{args[0]};
        setterMethod.invoke(this.internal, value);
        return proxy;
    }

    public static class Builder<B, T> {
        private final Class<B> builderClass;
        private final Class<T> targetClass;
        private T targetInstance;
        private String builderMethodPrefix;
        private String enumMappingMethod;

        private Builder(Class<B> builderClass, Class<T> targetClass) {
            this.builderClass = builderClass;
            this.targetClass = targetClass;
        }

        public Builder<B, T> withTargetInstance(T targetInstance) {
            this.targetInstance = targetInstance;
            return this;
        }

        public Builder<B, T> withBuilderMethodPrefix(String prefix) {
            this.builderMethodPrefix = prefix;
            return this;
        }

        public Builder<B, T> withEnumMappingMethod(String enumMappingMethod) {
            this.enumMappingMethod = enumMappingMethod;
            return this;
        }

        public B newInstance() {
            if (this.targetInstance == null) {
                this.targetInstance = MapProxy.builder(this.targetClass).withEnumMappingMethod(this.enumMappingMethod).newInstance();
            }
            return (B)Proxy.newProxyInstance(this.builderClass.getClassLoader(), new Class[]{this.builderClass}, (InvocationHandler)new MapBuilderProxy(this.targetInstance, this.builderMethodPrefix));
        }
    }
}

