/*
 * Decompiled with CFR 0.152.
 */
package hu.blackbelt.structured.map.proxy;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(CompositeClassLoader.class);
    private static final String MANDATORY_CLASS_LOADER_MESSAGE = "The ClassLoader argument must be non-null.";
    private CopyOnWriteArrayList<ClassLoader> classLoaders;

    public CompositeClassLoader(ClassLoader ... classLoaders) {
        super(CompositeClassLoader.class.getClassLoader());
        Arrays.stream(classLoaders).forEach(classLoader -> Preconditions.checkNotNull((Object)classLoader, (Object)MANDATORY_CLASS_LOADER_MESSAGE));
        this.classLoaders = Lists.newCopyOnWriteArrayList(Arrays.asList(classLoaders));
    }

    public void insert(ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)classLoader, (Object)MANDATORY_CLASS_LOADER_MESSAGE);
        throw new UnsupportedOperationException();
    }

    public void append(ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)classLoader, (Object)MANDATORY_CLASS_LOADER_MESSAGE);
        this.classLoaders.addIfAbsent(classLoader);
    }

    public void remove(ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)classLoader, (Object)MANDATORY_CLASS_LOADER_MESSAGE);
        this.classLoaders.remove(classLoader);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        log.trace("Finding {} class.", (Object)name);
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                Class<?> cl = classLoader.loadClass(name);
                log.trace("Class {} found using {} class loader.", (Object)name, (Object)classLoader);
                return cl;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        log.trace("Class {} not found.", (Object)name);
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        log.trace("Finding {} resource.", (Object)name);
        URL result = null;
        for (ClassLoader classLoader : this.classLoaders) {
            result = classLoader.getResource(name);
            if (result == null) continue;
            log.trace("Resource {} found using {} class loader.", (Object)name, (Object)classLoader);
            break;
        }
        if (result == null) {
            log.trace("Resource {} not found.", (Object)name);
        }
        return result;
    }
}

