/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage;

import java.io.File;
import org.gradle.api.logging.Logger;
import scoverage.Constants;
import scoverage.Coverage;
import scoverage.report.CoberturaXmlWriter;
import scoverage.report.ScoverageHtmlWriter;
import scoverage.report.ScoverageXmlWriter;

public class ScoverageWriter {
    private final Logger logger;

    public ScoverageWriter(Logger logger) {
        this.logger = logger;
    }

    public void write(File sourceDir, File reportDir, Coverage coverage, Boolean coverageOutputCobertura, Boolean coverageOutputXML, Boolean coverageOutputHTML, Boolean coverageDebug) {
        this.logger.info("[scoverage] Generating scoverage reports...");
        reportDir.mkdirs();
        if (coverageOutputCobertura.booleanValue()) {
            new CoberturaXmlWriter(sourceDir, reportDir).write(coverage);
            this.logger.info("[scoverage] Written Cobertura XML report to " + reportDir.getAbsolutePath() + File.separator + "cobertura.xml");
        }
        if (coverageOutputXML.booleanValue()) {
            new ScoverageXmlWriter(sourceDir, reportDir, false).write(coverage);
            this.logger.info("[scoverage] Written XML report to " + reportDir.getAbsolutePath() + File.separator + Constants.XMLReportFilename());
            if (coverageDebug.booleanValue()) {
                new ScoverageXmlWriter(sourceDir, reportDir, true).write(coverage);
                this.logger.info("[scoverage] Written XML report with debug information to " + reportDir.getAbsolutePath() + File.separator + Constants.XMLReportFilenameWithDebug());
            }
        }
        if (coverageOutputHTML.booleanValue()) {
            new ScoverageHtmlWriter(sourceDir, reportDir).write(coverage);
            this.logger.info("[scoverage] Written HTML report to " + reportDir.getAbsolutePath() + File.separator + "index.html");
        }
        this.logger.info("[scoverage] Coverage reports completed");
    }
}

