/*
 * Decompiled with CFR 0.152.
 */
package de.inetsoftware.jwebassembly.gradle;

import de.inetsoftware.jwebassembly.gradle.OutputFormat;
import de.inetsoftware.jwebassembly.gradle.WasmTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.TaskExecutionException;

class WasmCompiler {
    private URLClassLoader classLoader;
    private Class<?> jWebAssemblyClass;
    private Method addFile;
    private Method compileToBinary;
    private Method compileToText;
    private Method setProperty;
    private Method addLibrary;
    private WasmTask task;
    private Object instance;

    WasmCompiler(WasmTask task) {
        this.task = task;
        try {
            this.instance = this.getCompilerClass(task).newInstance();
        }
        catch (Exception ex) {
            throw new TaskExecutionException((Task)task, (Throwable)ex);
        }
    }

    private Class<?> getCompilerClass(WasmTask task) throws Exception {
        if (this.jWebAssemblyClass == null) {
            Project project = task.getProject();
            String compilerDependency = task.getCompilerVersion();
            if (compilerDependency == null || !compilerDependency.contains(":")) {
                compilerDependency = "de.inetsoftware:jwebassembly-compiler:" + compilerDependency;
            }
            project.getDependencies().add("wasmCompiler", (Object)compilerDependency);
            Configuration config = project.getConfigurations().getByName("wasmCompiler");
            ArrayList<URL> urls = new ArrayList<URL>();
            for (File file : config.getFiles()) {
                task.getLogger().lifecycle("\tcompiler: " + file.getName());
                urls.add(file.toURI().toURL());
            }
            this.classLoader = new URLClassLoader(urls.toArray(new URL[0]));
            this.jWebAssemblyClass = this.classLoader.loadClass("de.inetsoftware.jwebassembly.JWebAssembly");
            this.addFile = this.getMethod("addFile", File.class);
            this.compileToBinary = this.getMethod("compileToBinary", File.class);
            this.compileToText = this.getMethod("compileToText", Appendable.class);
            try {
                this.setProperty = this.getMethod("setProperty", String.class, String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                this.addLibrary = this.getMethod("addLibrary", File.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                Logger wasmLogger = (Logger)this.jWebAssemblyClass.getField("LOGGER").get(null);
                LogLevel level = task.getLogging().getLevel();
                if (level != null) {
                    switch (level) {
                        case DEBUG: {
                            wasmLogger.setLevel(Level.FINEST);
                            break;
                        }
                        case INFO: {
                            wasmLogger.setLevel(Level.INFO);
                            break;
                        }
                        case WARN: 
                        case QUIET: {
                            wasmLogger.setLevel(Level.WARNING);
                            break;
                        }
                        case ERROR: {
                            wasmLogger.setLevel(Level.SEVERE);
                        }
                    }
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return this.jWebAssemblyClass;
    }

    private Method getMethod(String name, Class<?> ... parameterTypes) throws Exception {
        Method method = this.jWebAssemblyClass.getMethod(name, parameterTypes);
        method.setAccessible(true);
        return method;
    }

    void addFile(@Nonnull File file) {
        try {
            this.addFile.invoke(this.instance, file);
            this.task.getLogger().debug("add file: " + file);
        }
        catch (InvocationTargetException ex) {
            throw new TaskExecutionException((Task)this.task, ex.getTargetException());
        }
        catch (Exception ex) {
            throw new TaskExecutionException((Task)this.task, (Throwable)ex);
        }
    }

    void addLibrary(@Nonnull File file) {
        try {
            if (this.addLibrary != null) {
                this.addLibrary.invoke(this.instance, file);
                this.task.getLogger().debug("add library: " + file);
            }
        }
        catch (InvocationTargetException ex) {
            throw new TaskExecutionException((Task)this.task, ex.getTargetException());
        }
        catch (Exception ex) {
            throw new TaskExecutionException((Task)this.task, (Throwable)ex);
        }
    }

    void compile() {
        block26: {
            try {
                if (this.setProperty != null) {
                    for (Map.Entry<String, String> entry : this.task.getProperties().entrySet()) {
                        this.setProperty.invoke(this.instance, entry.getKey(), entry.getValue());
                    }
                }
                if (this.task.getFormat() == OutputFormat.Binary) {
                    this.compileToBinary.invoke(this.instance, this.task.getArchivePath());
                    break block26;
                }
                Throwable throwable = null;
                try (OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(this.task.getArchivePath()), StandardCharsets.UTF_8);){
                    this.compileToText.invoke(this.instance, output);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (InvocationTargetException ex) {
                Throwable throwable = ex.getTargetException();
                String msg = "WasmException".equals(throwable.getClass().getSimpleName()) ? throwable.getMessage() : throwable.toString();
                this.task.getLogger().error("> WASM compile failed with: " + msg);
                throw new TaskExecutionException((Task)this.task, throwable);
            }
            catch (Exception ex) {
                throw new TaskExecutionException((Task)this.task, (Throwable)ex);
            }
            finally {
                if (this.classLoader != null) {
                    try {
                        this.classLoader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

