/*
 * Decompiled with CFR 0.152.
 */
package de.inetsoftware.jwebassembly.gradle;

import de.inetsoftware.jwebassembly.gradle.WasmTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class WasmPlugin
implements Plugin<Project> {
    static final String CONFIGURATION_NAME = "wasmCompiler";

    public void apply(Project project) {
        project.getPlugins().apply(JavaPlugin.class);
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet main = (SourceSet)javaConvention.getSourceSets().getByName("main");
        WasmTask wasm = (WasmTask)project.getTasks().create("wasm", WasmTask.class);
        wasm.setDescription("Assembles a jar archive containing the main classes.");
        wasm.setGroup("build");
        wasm.from(new Object[]{main.getOutput()});
        wasm.dependsOn(new Object[]{"classes"});
        Task build = project.getTasks().getByName("build");
        build.dependsOn(new Object[]{wasm});
        Configuration config = (Configuration)project.getConfigurations().create(CONFIGURATION_NAME);
        config.setVisible(false);
        config.setTransitive(true);
        config.setDescription("The WASM Compiler dependency.");
    }
}

