/*
 * Decompiled with CFR 0.152.
 */
package de.inetsoftware.jwebassembly.gradle;

import de.inetsoftware.jwebassembly.gradle.OutputFormat;
import de.inetsoftware.jwebassembly.gradle.WasmTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.TaskExecutionException;

class WasmCompiler {
    private static Class<?> jWebAssemblyClass;
    private static Method addFile;
    private static Method compileToBinary;
    private static Method compileToText;
    private static Method setProperty;
    private WasmTask task;
    private Object instance;

    WasmCompiler(WasmTask task) {
        this.task = task;
        try {
            this.instance = this.getCompilerClass(task).newInstance();
        }
        catch (Exception ex) {
            throw new TaskExecutionException((Task)task, (Throwable)ex);
        }
    }

    private Class<?> getCompilerClass(WasmTask task) throws Exception {
        if (jWebAssemblyClass == null) {
            Project project = task.getProject();
            project.getDependencies().add("wasmCompiler", (Object)("de.inetsoftware:jwebassembly-compiler:" + task.getCompilerVersion()));
            Configuration config = project.getConfigurations().getByName("wasmCompiler");
            ArrayList<URL> urls = new ArrayList<URL>();
            for (File file : config.getFiles()) {
                task.getLogger().lifecycle("\tcompiler: " + file.getName());
                urls.add(file.toURI().toURL());
            }
            URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[0]));
            jWebAssemblyClass = cl.loadClass("de.inetsoftware.jwebassembly.JWebAssembly");
            addFile = WasmCompiler.getMethod("addFile", File.class);
            compileToBinary = WasmCompiler.getMethod("compileToBinary", File.class);
            compileToText = WasmCompiler.getMethod("compileToText", Appendable.class);
            try {
                setProperty = WasmCompiler.getMethod("setProperty", String.class, String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return jWebAssemblyClass;
    }

    private static Method getMethod(String name, Class<?> ... parameterTypes) throws Exception {
        Method method = jWebAssemblyClass.getMethod(name, parameterTypes);
        method.setAccessible(true);
        return method;
    }

    void addFile(@Nonnull File file) {
        try {
            addFile.invoke(this.instance, file);
        }
        catch (InvocationTargetException ex) {
            throw new TaskExecutionException((Task)this.task, ex.getTargetException());
        }
        catch (Exception ex) {
            throw new TaskExecutionException((Task)this.task, (Throwable)ex);
        }
    }

    void compile() {
        block17: {
            try {
                if (setProperty != null) {
                    setProperty.invoke(this.instance, "DebugNames", Boolean.toString(this.task.isDebugNames()));
                }
                if (this.task.getFormat() == OutputFormat.Binary) {
                    compileToBinary.invoke(this.instance, this.task.getArchivePath());
                    break block17;
                }
                try (OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(this.task.getArchivePath()), StandardCharsets.UTF_8);){
                    compileToText.invoke(this.instance, output);
                }
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                String msg = "WasmException".equals(targetException.getClass().getSimpleName()) ? targetException.getMessage() : targetException.toString();
                this.task.getLogger().error("> WASM compile failed with: " + msg);
                throw new TaskExecutionException((Task)this.task, targetException);
            }
            catch (Exception ex) {
                throw new TaskExecutionException((Task)this.task, (Throwable)ex);
            }
        }
    }
}

