/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.util;

import com.inet.gradle.setup.util.Logging;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class TempPath {
    private Path tmp;

    public TempPath(Path root) {
        this.tmp = root;
        if (!this.tmp.toFile().exists()) {
            this.tmp.toFile().mkdirs();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    TempPath.this.clearTemporaryFolder();
                }
                catch (Exception e) {
                    System.err.println("Could not remove temporary Resources");
                    e.printStackTrace();
                }
            }
        }));
    }

    public TempPath() throws IOException {
        this(Files.createTempDirectory("SetupBuilder", new FileAttribute[0]));
    }

    public String get() {
        return this.tmp.toString();
    }

    public Path get(String directory) throws IOException {
        File destination = new File(this.tmp.toFile(), directory);
        if (!destination.exists()) {
            if (destination.mkdirs()) {
                Logging.sysout("Created temporary directory: " + destination);
            } else {
                Logging.sysout("Could not create temporary directory: " + destination);
            }
        } else {
            Logging.sysout("Directory did exist: " + destination);
        }
        return destination.toPath();
    }

    public File getTempFile(String directory, String file) throws IOException {
        return new File(this.get(directory).toFile(), file);
    }

    public File getTempFile(String file) {
        return new File(this.get(), file);
    }

    public String getTempString(String file) {
        return this.getTempFile(file).toString();
    }

    public String getTempString(String directory, String file) throws IOException {
        return new File(this.get(directory).toFile(), file).toString();
    }

    private void clearTemporaryFolder() throws Exception {
        TempPath.clearTemporaryFolder(this.tmp);
    }

    public static void clearTemporaryFolder(Path tmp) throws Exception {
        Files.walkFileTree(tmp, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        Logging.sysout("Removed the temporary content at: " + tmp.toString());
    }
}

