/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.util;

import com.inet.gradle.setup.util.Logging;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ResourceUtils {
    public static File extract(Class<?> clazz, String name, File dir) throws IOException {
        File file = new File(dir, name);
        file.getParentFile().mkdirs();
        try (InputStream input = clazz.getResourceAsStream(name);){
            Files.copy(input, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return file;
    }

    public static void unZipIt(File file, File folder) {
        ResourceUtils.unZipIt(file, folder, null);
    }

    public static void unZipIt(File file, File folder, Function<String, String> nameClosure) {
        ResourceUtils.unZipIt(file, folder, nameClosure, null);
    }

    public static void unZipIt(File file, File folder, Function<String, String> nameClosure, Function<InputStream, InputStream> streamClosure) {
        ResourceUtils.unZipIt(file, folder, "", nameClosure, null);
    }

    public static void unZipIt(File file, File folder, String startsWith, Function<String, String> nameClosure, Function<InputStream, InputStream> streamClosure) {
        if (!folder.exists()) {
            folder.mkdir();
        }
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String fileName = zipEntry.getName();
                if (zipEntry.isDirectory() || !fileName.startsWith(startsWith)) continue;
                fileName = fileName.substring(startsWith.length());
                if (nameClosure != null) {
                    fileName = nameClosure.apply(fileName);
                }
                InputStream input = zipFile.getInputStream(zipEntry);
                Throwable throwable = null;
                try {
                    File target = new File(folder, fileName);
                    target.getParentFile().mkdirs();
                    InputStream stream = input;
                    if (streamClosure != null) {
                        stream = streamClosure.apply(input);
                    }
                    Files.copy(stream, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    input.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void deleteDirectory(Path directoryPath) throws IOException {
        Files.walkFileTree(directoryPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exception) throws IOException {
                if (exception == null) {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
                throw exception;
            }
        });
    }

    public static File extractDirectory(String path, File destination) throws Exception {
        URL dirURL;
        if (!(path = path.replaceAll("\\.", "/")).endsWith("/")) {
            path = path + "/";
        }
        if ((dirURL = ResourceUtils.class.getClassLoader().getResource(path)) != null && dirURL.getProtocol().equals("file")) {
            Logging.sysout("Input is already an existing file: " + dirURL);
            return new File(dirURL.toURI());
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            Logging.sysout("Checking Jar for files: " + jarPath);
            Logging.sysout("Path to look for: " + path);
            while (entries.hasMoreElements()) {
                JarEntry nextElement = entries.nextElement();
                String name = nextElement.getName();
                Logging.sysout("Checking: " + name);
                if (!name.startsWith(path)) continue;
                String entry = name.substring(path.length());
                int checkSubdir = entry.indexOf("/");
                if (checkSubdir >= 0) {
                    File nDest = new File(destination, entry.substring(0, checkSubdir));
                    if (!nDest.exists()) {
                        nDest.mkdirs();
                    }
                    ResourceUtils.extractDirectory(name, nDest);
                    continue;
                }
                if (entry.isEmpty()) continue;
                InputStream input = jar.getInputStream(nextElement);
                Throwable throwable = null;
                try {
                    File output = new File(destination, entry);
                    Files.copy(input, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    input.close();
                }
            }
            jar.close();
            return destination;
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }

    public static void copy(File source, File destination) throws IOException {
        Path sourcePath = source.toPath();
        Path destinationPath = destination.toPath();
        destination.getParentFile().mkdirs();
        Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING, LinkOption.NOFOLLOW_LINKS, StandardCopyOption.COPY_ATTRIBUTES);
        if (Files.isDirectory(sourcePath, new LinkOption[0]) && !Files.isSymbolicLink(sourcePath)) {
            String[] files = source.list();
            for (int i = 0; i < files.length; ++i) {
                String file = files[i];
                ResourceUtils.copy(new File(source, file), new File(destination, file));
            }
        }
    }
}

