/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class ReplacingInputStream
extends FilterInputStream {
    private final Map<byte[], byte[]> replacements = new TreeMap<byte[], byte[]>(new Comparator<byte[]>(){

        @Override
        public int compare(byte[] b1, byte[] b2) {
            if (b1.length != b2.length) {
                return b2.length - b1.length;
            }
            for (int i = 0; i < b1.length; ++i) {
                if (b1[i] == b2[i]) continue;
                return b2[i] - b1[i];
            }
            return 0;
        }
    });
    private byte[] pushBackBuffer;
    private int pushBackPosition;
    private final ByteBuffer singleByteReadBuffer;
    private ByteBuffer cachedClientBuffer;
    private int endIndex;
    private int skip;
    private boolean replacementOccurred;
    private int readFromStream;

    public ReplacingInputStream(InputStream in, Map<byte[], byte[]> replacements) throws IllegalArgumentException {
        super(in);
        if (replacements == null) {
            throw new IllegalArgumentException("Can't create ReplaceFilterInputStream for the 'null' replacements. Given input stream to process: " + in);
        }
        boolean replacementsValid = false;
        for (Map.Entry<byte[], byte[]> entry : replacements.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("Can't create ReplaceFilterInputStream. Reason: given replacements holds null as one of keys. Replacements: " + replacements);
            }
            if (entry.getValue() == null) {
                throw new IllegalArgumentException(String.format("Can't create ReplaceFilterInputStream. Reason: given replacements holds null as value of key (%s). Replacements: %s", Arrays.toString(entry.getKey()), replacements));
            }
            if (entry.getKey().length <= 0) continue;
            replacementsValid = true;
        }
        if (!replacementsValid) {
            this.singleByteReadBuffer = null;
            return;
        }
        this.replacements.putAll(replacements);
        int length = ReplacingInputStream.getMaxLength(replacements.keySet(), replacements.values());
        this.singleByteReadBuffer = ByteBuffer.allocate(length);
        this.pushBackBuffer = new byte[2 * length];
        this.pushBackPosition = this.pushBackBuffer.length - 1;
    }

    @Override
    public int read() throws IOException {
        int read;
        if (this.replacements.isEmpty()) {
            return super.read();
        }
        this.replacementOccurred = true;
        do {
            this.singleByteReadBuffer.clear();
        } while ((read = this.doRead(this.singleByteReadBuffer, 1)) == 0 && (this.replacementOccurred || this.readFromStream >= 0));
        if (read == 0 && !this.replacementOccurred) {
            return this.pushBackBuffer[++this.pushBackPosition];
        }
        if (read < 0) {
            return read;
        }
        int toUnread = this.singleByteReadBuffer.remaining() - 1;
        if (toUnread > 0) {
            this.unread(this.singleByteReadBuffer.array(), this.singleByteReadBuffer.position() + 1, toUnread);
            this.skip += toUnread;
        }
        return this.singleByteReadBuffer.get(0);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        ByteBuffer bufferToUse;
        int result;
        if (this.replacements.isEmpty()) {
            return super.read(b, off, len);
        }
        if (b == null) {
            throw new NullPointerException(String.format("Can't process ReplaceFilterInputStream.read() for the null buffer reference. Given offset: %d, length: %d", off, len));
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException("Can't process ReplaceFilterInputStream.read(). Reason: given offset is negative (" + off + ")");
        }
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException("Can't process ReplaceFilterInputStream.read(). Reason: given length is negative (" + len + ")");
        }
        if (len > b.length - off) {
            throw new ArrayIndexOutOfBoundsException(String.format("Can't process ReplaceFilterInputStream.read(). Reason: given length (%d) is more than buffer's max available length (%d, implied by buffer length (%d) - offset (%d))", len, b.length - off, b.length, off));
        }
        while ((result = this.doRead(bufferToUse = this.wrapForBufferedReading(b, off, len), len)) == 0 && (this.replacementOccurred || this.readFromStream >= 0)) {
        }
        if (result == 0 && !this.replacementOccurred) {
            result = this.pushBackBuffer.length - this.pushBackPosition - 1;
            System.arraycopy(this.pushBackBuffer, this.pushBackPosition + 1, b, off, result);
            this.pushBackPosition += result;
            return result;
        }
        if (bufferToUse.array() == b) {
            return result;
        }
        if (result > len) {
            this.unread(bufferToUse.array(), off + len, result - len);
        }
        System.arraycopy(bufferToUse.array(), off, b, off, len);
        return Math.min(result, len);
    }

    private ByteBuffer wrapForBufferedReading(byte[] b, int off, int len) {
        if (this.cachedClientBuffer == null || this.cachedClientBuffer.array() != b) {
            this.cachedClientBuffer = ByteBuffer.wrap(b);
        }
        if (len < this.singleByteReadBuffer.capacity()) {
            this.singleByteReadBuffer.clear();
            return this.singleByteReadBuffer;
        }
        this.cachedClientBuffer.position(off);
        this.cachedClientBuffer.limit(off + len);
        return this.cachedClientBuffer;
    }

    private static int getMaxLength(Iterable<byte[]> ... iterables) {
        int result = -1;
        for (Iterable<byte[]> iterable : iterables) {
            for (byte[] array : iterable) {
                result = Math.max(result, array.length);
            }
        }
        return result;
    }

    private int doRead(ByteBuffer buffer, int targetBytesNumber) throws IOException {
        this.replacementOccurred = false;
        buffer.mark();
        this.endIndex = buffer.limit();
        int initalPosition = buffer.position();
        int read = this.prepare(buffer);
        if (read < 0) {
            return read;
        }
        boolean continueIteration = true;
        while (continueIteration && buffer.hasRemaining()) {
            if (buffer.position() - initalPosition >= targetBytesNumber) {
                this.unread(buffer.array(), buffer.position(), buffer.remaining());
                buffer.limit(buffer.position());
                break;
            }
            boolean processed = false;
            block5: for (Map.Entry<byte[], byte[]> entry : this.replacements.entrySet()) {
                ReplacementResult replacementResult = this.tryToReplace(buffer, entry.getKey(), entry.getValue());
                switch (replacementResult) {
                    case NOT_MATCHED: {
                        continue block5;
                    }
                    case NOT_ENOUGH_DATA: {
                        continueIteration = false;
                    }
                }
                processed = true;
                break;
            }
            if (processed || !continueIteration) continue;
            buffer.position(buffer.position() + 1);
        }
        return buffer.position() - buffer.reset().position();
    }

    private int prepare(ByteBuffer buffer) throws IOException {
        int pushedInBytes = 0;
        if (this.pushBackPosition + 1 < this.pushBackBuffer.length) {
            pushedInBytes = Math.min(buffer.remaining(), this.pushBackBuffer.length - this.pushBackPosition - 1);
            System.arraycopy(this.pushBackBuffer, this.pushBackPosition + 1, buffer.array(), buffer.position(), pushedInBytes);
            this.pushBackPosition += pushedInBytes;
        }
        this.readFromStream = this.in.read(buffer.array(), buffer.position() + pushedInBytes, buffer.remaining() - pushedInBytes);
        if (this.readFromStream < 0 && pushedInBytes <= 0) {
            return this.readFromStream;
        }
        int read = pushedInBytes;
        if (this.readFromStream > 0) {
            read += this.readFromStream;
        }
        buffer.limit(buffer.position() + read);
        if (this.skip > 0) {
            int skipNow = Math.min(this.skip, read);
            this.skip -= skipNow;
            buffer.position(buffer.position() + skipNow);
        }
        return read;
    }

    private ReplacementResult tryToReplace(ByteBuffer data, byte[] replacementFrom, byte[] replacementTo) {
        ReplacementResult result = ReplacementResult.REPLACED;
        int position = data.position();
        for (byte b : replacementFrom) {
            if (!data.hasRemaining()) {
                result = ReplacementResult.NOT_ENOUGH_DATA;
                this.unread(data.array(), position, data.position() - position);
                data.limit(position);
                break;
            }
            if (b == data.get()) continue;
            result = ReplacementResult.NOT_MATCHED;
            break;
        }
        if (result == ReplacementResult.NOT_MATCHED || result == ReplacementResult.NOT_ENOUGH_DATA) {
            data.position(position);
            return result;
        }
        this.replacementOccurred = true;
        if (replacementFrom.length >= replacementTo.length) {
            this.replaceWithReduce(data, position, replacementFrom, replacementTo);
        } else {
            this.replaceWithExpand(data, position, replacementFrom, replacementTo);
        }
        return result;
    }

    private void replaceWithReduce(ByteBuffer data, int startPosition, byte[] replacementFrom, byte[] replacementTo) {
        if (replacementTo.length > 0) {
            System.arraycopy(replacementTo, 0, data.array(), startPosition, replacementTo.length);
        }
        int newPosition = startPosition + replacementTo.length;
        if (data.remaining() > 0) {
            System.arraycopy(data.array(), data.position(), data.array(), newPosition, data.remaining());
        }
        data.position(newPosition);
        data.limit(data.limit() - replacementFrom.length + replacementTo.length);
    }

    private void replaceWithExpand(ByteBuffer data, int initialPostiion, byte[] replacementFrom, byte[] replacementTo) {
        int moveLength;
        int diff = replacementTo.length - replacementFrom.length;
        int bufferFreeSpace = this.endIndex - data.limit();
        int totalUnread = diff - bufferFreeSpace;
        int unreadBufferSize = Math.min(totalUnread, data.remaining());
        int unread = totalUnread;
        if (unread > 0 && unreadBufferSize > 0) {
            this.unread(data.array(), data.limit() - unreadBufferSize, unreadBufferSize);
            unread -= unreadBufferSize;
        }
        int replacementLength = replacementTo.length;
        if (unread > 0) {
            this.unread(replacementTo, replacementTo.length - unread, unread);
            replacementLength -= unread;
            this.skip += unread;
        }
        if ((moveLength = data.remaining() - unreadBufferSize) > 0) {
            System.arraycopy(data.array(), data.position(), data.array(), initialPostiion + replacementLength, moveLength);
            data.limit(Math.min(data.limit() + moveLength, data.capacity()));
        }
        System.arraycopy(replacementTo, 0, data.array(), initialPostiion, replacementLength);
        int newPosition = initialPostiion + replacementLength;
        if (newPosition > data.limit() && newPosition <= this.endIndex) {
            data.limit(newPosition);
        }
        data.position(newPosition);
    }

    private void unread(byte[] buffer, int offset, int length) {
        if (this.pushBackPosition + 1 < length) {
            byte[] newBuffer = new byte[this.pushBackBuffer.length * 2];
            int newPosition = this.pushBackBuffer.length + this.pushBackPosition;
            int bytesToCopy = this.pushBackBuffer.length - this.pushBackPosition - 1;
            System.arraycopy(this.pushBackBuffer, this.pushBackPosition + 1, newBuffer, newPosition + 1, bytesToCopy);
            this.pushBackPosition = newPosition;
            this.pushBackBuffer = newBuffer;
        }
        System.arraycopy(buffer, offset, this.pushBackBuffer, this.pushBackPosition - length + 1, length);
        this.pushBackPosition -= length;
    }

    private static enum ReplacementResult {
        REPLACED,
        NOT_MATCHED,
        NOT_ENOUGH_DATA;

    }
}

