/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.unix.deb;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.abstracts.LocalizedResource;
import com.inet.gradle.setup.unix.deb.Deb;
import com.inet.gradle.setup.unix.deb.DebBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;
import java.util.zip.GZIPOutputStream;

class DebDocumentFileBuilder {
    private static final String NEWLINE = "\n";
    private final Deb deb;
    private final SetupBuilder setup;
    private File buildDir;

    DebDocumentFileBuilder(Deb deb, SetupBuilder setup, File buildDir) {
        this.deb = deb;
        this.setup = setup;
        this.buildDir = buildDir;
    }

    void build() throws Exception {
        this.createChangelogFile();
        this.copyCopyrightFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyCopyrightFile() throws FileNotFoundException, IOException {
        File copyright = new File(this.buildDir, "copyright");
        if (!copyright.getParentFile().exists()) {
            copyright.getParentFile().mkdirs();
        }
        FileOutputStream fileoutput = null;
        OutputStreamWriter controlWriter = null;
        fileoutput = new FileOutputStream(copyright);
        controlWriter = new OutputStreamWriter((OutputStream)fileoutput, "UTF-8");
        controlWriter.write("Format: http://www.debian.org/doc/packaging-manuals/copyright-format/1.0/\n");
        controlWriter.write("Upstream-Name: " + this.setup.getArchiveName() + NEWLINE);
        controlWriter.write("Source: " + this.deb.getHomepage() + NEWLINE);
        for (LocalizedResource localizedResource : this.setup.getLicenseFiles()) {
            StringBuffer content = new StringBuffer();
            content.append(NEWLINE);
            content.append("File: *\n");
            content.append("Copyright: " + this.setup.getCopyright() + NEWLINE);
            String lang = localizedResource.getLanguage().equalsIgnoreCase(this.setup.getDefaultResourceLanguage()) ? "" : " and " + localizedResource.getLanguage();
            content.append("License: commercial" + lang + NEWLINE);
            try {
                Scanner scanner = new Scanner(localizedResource.getResource(), "UTF8");
                Throwable throwable = null;
                try {
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        content.append(" " + (line.isEmpty() ? Character.valueOf('.') : line) + NEWLINE);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (scanner == null) continue;
                    if (throwable != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    scanner.close();
                }
            }
            finally {
                controlWriter.write(content + NEWLINE);
            }
        }
        controlWriter.flush();
        controlWriter.close();
        DebBuilder.setPermissions(copyright, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createChangelogFile() throws IOException {
        FileOutputStream fileoutput = null;
        OutputStreamWriter controlWriter = null;
        try {
            File changelog = new File(this.buildDir, "changelog.gz");
            if (!changelog.getParentFile().exists()) {
                changelog.getParentFile().mkdirs();
            }
            fileoutput = new FileOutputStream(changelog);
            GZIPOutputStream gzipstream = new GZIPOutputStream(fileoutput);
            controlWriter = new OutputStreamWriter((OutputStream)gzipstream, "UTF-8");
            controlWriter.write(this.setup.getAppIdentifier() + " (" + this.deb.getVersion() + ") unstable; urgency=low" + NEWLINE + NEWLINE);
            String changes = this.deb.getChanges();
            if (changes != null && changes.length() > 0) {
                controlWriter.write(changes + NEWLINE);
            } else {
                controlWriter.write("  * no changes\n");
            }
            controlWriter.write("\n -- " + this.setup.getVendor() + " <" + this.deb.getMaintainerEmail() + ">  " + new SimpleDateFormat("dd MMM yyyy HH:mm:ss Z").format(new Date(System.currentTimeMillis())) + NEWLINE);
            controlWriter.flush();
            DebBuilder.setPermissions(changelog, false);
        }
        finally {
            if (controlWriter != null) {
                try {
                    controlWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (fileoutput != null) {
                try {
                    fileoutput.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

