/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.msi;

import com.inet.gradle.setup.abstracts.AbstractSetupTask;
import com.inet.gradle.setup.msi.Launch4j;
import com.inet.gradle.setup.msi.MsiBuilder;
import com.inet.gradle.setup.msi.MsiLanguages;
import com.inet.gradle.setup.msi.MsiLocalizedResource;
import com.inet.gradle.setup.msi.SignTool;
import com.inet.gradle.setup.util.ResourceUtils;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.internal.file.CopyActionProcessingStreamAction;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.util.ConfigureUtil;

public class Msi
extends AbstractSetupTask {
    private String arch;
    private boolean only32bit;
    private Object bannerBmp;
    private Object dialogBmp;
    private Object wxsTemplate;
    private Object multiInstanceScript;
    private List<String> languages;
    private SignTool signTool;
    private double minOS;
    private List<Launch4j> launch4j = new ArrayList<Launch4j>();
    private int multiInstanceCount = 1;
    private InstallScope installScope;
    private List<String> preGUI = new ArrayList<String>();
    private boolean runAfterIsOptional = false;
    private List<MsiLocalizedResource> i18n = new ArrayList<MsiLocalizedResource>();
    private List<File> externals = new ArrayList<File>();

    public Msi() {
        super("msi");
    }

    @Override
    public void build() {
        try {
            MsiLocalizedResource resource = new MsiLocalizedResource(this.getSetupBuilder(), this.getTemporaryDir());
            resource.setLocale("en");
            resource.setOverridable(true);
            resource.setResource(ResourceUtils.extract(this.getClass(), "i18n/language-en.properties", this.getTemporaryDir()));
            this.i18n.add(resource);
            resource = new MsiLocalizedResource(this.getSetupBuilder(), this.getTemporaryDir());
            resource.setLocale("de");
            resource.setOverridable(true);
            resource.setResource(ResourceUtils.extract(this.getClass(), "i18n/language-de.properties", this.getTemporaryDir()));
            this.i18n.add(resource);
        }
        catch (IOException e) {
            throw new GradleException("Could not extract required ressources.", (Throwable)e);
        }
        ProjectInternal project = (ProjectInternal)this.getProject();
        new MsiBuilder(this, this.getSetupBuilder(), project.getFileResolver()).build();
    }

    @Override
    protected void processFiles(CopyActionProcessingStreamAction action) {
        super.processFiles(action);
    }

    boolean isOnly32Bit() {
        return this.only32bit;
    }

    public String getArch() {
        if (this.arch != null) {
            return this.arch;
        }
        return "x64";
    }

    public void setArch(String arch) {
        if ("x86-only".equals(arch)) {
            this.arch = "x86";
            this.only32bit = true;
        } else {
            this.arch = arch;
            this.only32bit = false;
        }
    }

    boolean is64Bit() {
        switch (this.getArch()) {
            case "x64": 
            case "ia64": {
                return true;
            }
        }
        return false;
    }

    public File getBannerBmp() {
        if (this.bannerBmp != null) {
            return this.getProject().file(this.bannerBmp);
        }
        return null;
    }

    public void setBannerBmp(Object bannerBmp) {
        this.bannerBmp = bannerBmp;
    }

    public File getDialogBmp() {
        if (this.dialogBmp != null) {
            return this.getProject().file(this.dialogBmp);
        }
        return null;
    }

    public void setDialogBmp(Object dialogBmp) {
        this.dialogBmp = dialogBmp;
    }

    public void signTool(Closure<SignTool> closue) {
        this.signTool = (SignTool)ConfigureUtil.configure(closue, (Object)new SignTool());
    }

    public SignTool getSignTool() {
        return this.signTool;
    }

    public URL getWxsTemplate() throws MalformedURLException {
        if (this.wxsTemplate != null) {
            return this.getProject().file(this.wxsTemplate).toURI().toURL();
        }
        return this.getClass().getResource("template.wxs");
    }

    public void setWxsTemplate(Object wxsTemplate) {
        this.wxsTemplate = wxsTemplate;
    }

    public List<MsiLanguages> getLanguages() {
        ArrayList<MsiLanguages> result = new ArrayList<MsiLanguages>();
        if (this.languages == null) {
            Collections.addAll(result, MsiLanguages.values());
            return result;
        }
        for (String lang : this.languages) {
            result.add(MsiLanguages.getMsiLanguage(lang));
        }
        if (result.isEmpty()) {
            result.add(MsiLanguages.en_us);
        }
        return result;
    }

    public void setLanguages(Object languages) {
        List<Object> list;
        if (languages == null) {
            list = null;
        } else if (languages instanceof Iterable) {
            list = new ArrayList();
            for (Object str : (Iterable)languages) {
                list.add(str.toString());
            }
        } else {
            list = Arrays.asList(languages.toString());
        }
        this.languages = list;
    }

    public double getMinOS() {
        return this.minOS;
    }

    public void setMinOS(double minVersion) {
        this.minOS = minVersion;
    }

    public void launch4j(Closure<Launch4j> closue) {
        Launch4j launcher = (Launch4j)ConfigureUtil.configure(closue, (Object)new Launch4j(this.getSetupBuilder()));
        this.launch4j.add(launcher);
    }

    public List<Launch4j> getLaunch4js() {
        return this.launch4j;
    }

    public int getMultiInstanceCount() {
        return this.multiInstanceCount;
    }

    public void setMultiInstanceCount(int instanceCount) {
        this.multiInstanceCount = instanceCount;
    }

    public URL getMultiInstanceScript() throws MalformedURLException {
        if (this.multiInstanceScript != null) {
            return this.getProject().file(this.multiInstanceScript).toURI().toURL();
        }
        return this.getClass().getResource("MultiInstance.vbs");
    }

    public void setMultiInstanceScript(Object multiInstanceScript) {
        this.multiInstanceScript = multiInstanceScript;
    }

    public InstallScope getInstallScope() {
        if (this.installScope != null) {
            return this.installScope;
        }
        return InstallScope.perMachine;
    }

    public void setInstallScope(InstallScope installScope) {
        this.installScope = installScope;
    }

    public List<String> getPreGUI() {
        return this.preGUI;
    }

    public void setPreGUI(Object script) {
        this.preGUI.clear();
        this.preGUI(script);
    }

    public void preGUI(Object script) {
        if (script != null) {
            if (script instanceof Collection) {
                this.preGUI.addAll((Collection)script);
            } else {
                this.preGUI.add(script.toString());
            }
        }
    }

    public boolean isRunAfterOptional() {
        return this.runAfterIsOptional;
    }

    public void setRunAfterIsOptional(boolean runAfterIsOptional) {
        this.runAfterIsOptional = runAfterIsOptional;
    }

    public void i18n(Object localization) {
        MsiLocalizedResource.addLocalizedResource(this.getSetupBuilder(), this.getTemporaryDir(), this.i18n, localization);
    }

    public List<MsiLocalizedResource> getI18n() {
        return this.i18n;
    }

    public Msi external(File external) {
        this.externals.add(external);
        return this;
    }

    public Msi setExternals(Iterable<File> externals) {
        this.externals.clear();
        for (File external : externals) {
            this.externals.add(external);
        }
        return this;
    }

    public List<File> getExternals() {
        return this.externals;
    }

    public static enum InstallScope {
        perUser,
        perMachine;

    }
}

