/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.msi;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.msi.Launch4j;
import com.inet.gradle.setup.msi.Launch4jConfig;
import com.inet.gradle.setup.msi.Msi;
import com.inet.gradle.setup.util.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public class Launch4jCreator {
    private URLClassLoader lauch4jClassLoader;

    File create(Launch4j launch, Msi task, SetupBuilder setup) throws Exception {
        Launch4jConfig config = new Launch4jConfig(launch, task, setup);
        File outfile = config.build();
        config.save();
        Class<?> clazz = Class.forName("net.sf.launch4j.Main", true, this.getClassLoader(task.getProject(), task.getTemporaryDir()));
        String[] args = new String[]{config.xmlFile.getAbsolutePath()};
        clazz.getMethod("main", String[].class).invoke(null, new Object[]{args});
        if (!outfile.exists()) {
            throw new GradleException("Launch4j failed. ");
        }
        return outfile;
    }

    private ClassLoader getClassLoader(Project project, File buildDir) throws IOException {
        if (this.lauch4jClassLoader == null) {
            String configName = "setupLaunch4j";
            Configuration config = (Configuration)project.getConfigurations().findByName(configName);
            if (config == null) {
                config = (Configuration)project.getConfigurations().create(configName);
                config.setVisible(false);
                config.setTransitive(false);
                DependencyHandler dependencies = project.getDependencies();
                dependencies.add(configName, (Object)"net.sf.launch4j:launch4j:3.12");
                dependencies.add(configName, (Object)"net.sf.launch4j:launch4j:3.12:workdir-win32");
                dependencies.add(configName, (Object)"com.thoughtworks.xstream:xstream:1.4.11.1");
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            File libDir = new File(buildDir, "launch4jlib");
            libDir.mkdirs();
            for (File file : config.getFiles()) {
                String name = file.getName();
                if (!name.endsWith(".jar")) continue;
                if (name.contains("-workdir-")) {
                    String internalName = name = name.substring(0, name.length() - 4);
                    ResourceUtils.unZipIt(file, libDir, entryName -> {
                        if (entryName.startsWith(internalName)) {
                            entryName = entryName.substring(internalName.length() + 1);
                        }
                        return entryName;
                    });
                    continue;
                }
                File target = new File(libDir, file.getName());
                Files.copy(file.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                urls.add(target.toURI().toURL());
            }
            this.lauch4jClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
        }
        return this.lauch4jClassLoader;
    }

    void close() throws IOException {
        if (this.lauch4jClassLoader != null) {
            this.lauch4jClassLoader.close();
            this.lauch4jClassLoader = null;
        }
    }
}

