/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.msi;

import com.inet.gradle.setup.SetupBuilder;
import com.inet.gradle.setup.msi.Launch4j;
import com.inet.gradle.setup.msi.Launch4jManifest;
import com.inet.gradle.setup.msi.Msi;
import com.inet.gradle.setup.util.XmlFileBuilder;
import java.io.File;
import org.w3c.dom.Element;

class Launch4jConfig
extends XmlFileBuilder<Msi> {
    private Launch4j launch;

    Launch4jConfig(Launch4j launch, Msi task, SetupBuilder setup) throws Exception {
        super(task, setup, File.createTempFile("launch4j", ".xml", task.getTemporaryDir()), task.getTemporaryDir(), null);
        this.launch = launch;
    }

    File build() throws Exception {
        String exe = this.launch.getExecutable();
        if (exe == null) {
            throw new RuntimeException("No executable set for launch4j.");
        }
        File outfile = new File(this.buildDir, exe);
        Element launch4jConfig = this.getOrCreateChild(this.doc, "launch4jConfig");
        this.getOrCreateChild(launch4jConfig, "headerType").setTextContent("gui");
        this.getOrCreateChild(launch4jConfig, "dontWrapJar").setTextContent("true");
        String mainClass = this.launch.getMainClass();
        if (mainClass == null || mainClass.isEmpty()) {
            this.getOrCreateChild(launch4jConfig, "jar").setTextContent(this.launch.getMainJar());
        } else {
            Element classPath = this.getOrCreateChild(launch4jConfig, "classPath");
            this.getOrCreateChild(classPath, "mainClass").setTextContent(mainClass);
            this.getOrCreateChild(classPath, "cp").setTextContent(this.launch.getMainJar());
        }
        String args = this.launch.getStartArguments();
        if (!args.isEmpty()) {
            this.getOrCreateChild(launch4jConfig, "cmdLine").setTextContent(args);
        }
        this.getOrCreateChild(launch4jConfig, "outfile").setTextContent(outfile.getAbsolutePath());
        this.getOrCreateChild(launch4jConfig, "errTitle").setTextContent(this.launch.getDisplayName());
        this.getOrCreateChild(launch4jConfig, "chdir").setTextContent(".");
        File ico = this.launch.getIconForType(this.buildDir, "ico");
        if (ico != null) {
            this.getOrCreateChild(launch4jConfig, "icon").setTextContent(ico.getAbsolutePath());
        }
        Element jre = this.getOrCreateChild(launch4jConfig, "jre");
        Object bundleJRE = this.setup.getBundleJre();
        if (bundleJRE != null) {
            Object jreTarget = this.setup.getBundleJreTarget();
            String workDir = this.launch.getWorkDir();
            if (workDir != null && !workDir.isEmpty() && !workDir.equals(".")) {
                int count = workDir.split("[/\\\\]").length;
                for (int i = 0; i < count; ++i) {
                    jreTarget = "..\\" + (String)jreTarget;
                }
            }
            this.getOrCreateChild(jre, "path").setTextContent((String)jreTarget);
        } else {
            this.getOrCreateChild(jre, "minVersion").setTextContent(System.getProperty("java.version"));
        }
        this.getOrCreateChild(jre, "runtimeBits").setTextContent(((Msi)this.task).is64Bit() ? "64" : "32");
        for (String argument : this.launch.getJavaVMArguments()) {
            this.getOrCreateChild(jre, "opt", argument, true);
        }
        Element versionInfo = this.getOrCreateChild(launch4jConfig, "versionInfo");
        this.getOrCreateChild(versionInfo, "fileVersion").setTextContent(Launch4jConfig.normalizeVersionNumber(((Msi)this.task).getVersion()));
        this.getOrCreateChild(versionInfo, "txtFileVersion").setTextContent(((Msi)this.task).getVersion());
        this.getOrCreateChild(versionInfo, "productVersion").setTextContent(Launch4jConfig.normalizeVersionNumber(((Msi)this.task).getVersion()));
        this.getOrCreateChild(versionInfo, "txtProductVersion").setTextContent(((Msi)this.task).getVersion());
        this.getOrCreateChild(versionInfo, "fileDescription").setTextContent(this.launch.getDescription());
        this.getOrCreateChild(versionInfo, "productName").setTextContent(this.setup.getApplication());
        this.getOrCreateChild(versionInfo, "companyName").setTextContent(this.setup.getVendor());
        this.getOrCreateChild(versionInfo, "copyright").setTextContent(this.setup.getCopyright());
        this.getOrCreateChild(versionInfo, "originalFilename").setTextContent(exe);
        int idx = exe.lastIndexOf(46);
        if (idx > 0) {
            exe = exe.substring(0, idx);
        }
        this.getOrCreateChild(versionInfo, "internalName").setTextContent(exe);
        Launch4jManifest manifest = new Launch4jManifest(this.launch, (Msi)this.task, this.setup);
        manifest.build();
        manifest.save();
        this.getOrCreateChild(launch4jConfig, "manifest").setTextContent(manifest.xmlFile.getAbsolutePath());
        return outfile;
    }

    static String normalizeVersionNumber(String version) {
        String[] digits = version.split("[.]");
        StringBuilder newVersion = new StringBuilder();
        int count = 0;
        for (int i = 0; i < digits.length && count < 4; ++count, ++i) {
            String digit = digits[i];
            try {
                Integer.parseInt(digit);
            }
            catch (NumberFormatException e) {
                digit = "0";
            }
            newVersion.append('.').append(digit);
        }
        while (count < 4) {
            newVersion.append(".0");
            ++count;
        }
        return newVersion.substring(1);
    }
}

