/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.msi;

import com.inet.gradle.setup.abstracts.Application;

class CommandLine {
    final String relativTarget;
    final String relativFull;
    final String target;
    final String arguments;
    final String full;
    final String workDir;

    CommandLine(Application starter, String javaDir) {
        String dir;
        String target = starter.getExecutable();
        String arguments = starter.getStartArguments();
        String vmArguments = String.join((CharSequence)" ", starter.getJavaVMArguments()).trim();
        String workDir = starter.getWorkDir();
        if (workDir == null) {
            workDir = "";
        } else if (!(workDir = workDir.replace('/', '\\')).isEmpty() && !workDir.endsWith("\\")) {
            workDir = workDir + '\\';
        }
        if (target == null || target.isEmpty()) {
            target = javaDir != null ? "[INSTALLDIR]" + javaDir + "\\bin\\javaw.exe" : "javaw.exe";
            dir = "";
            arguments = vmArguments + " -cp \"[INSTALLDIR]" + workDir + starter.getMainJar() + "\" " + starter.getMainClass() + " " + arguments;
        } else if (!target.startsWith("[")) {
            dir = "[INSTALLDIR]";
            target = workDir + target;
        } else {
            dir = "";
        }
        this.relativTarget = target;
        this.target = dir + target;
        this.arguments = arguments;
        this.full = this.target.indexOf(32) >= 0 || this.target.indexOf(91) >= 0 ? '\"' + this.target + "\" " + arguments : this.target + ' ' + arguments;
        this.relativFull = this.relativTarget.indexOf(32) >= 0 || this.relativTarget.indexOf(91) >= 0 ? '\"' + this.relativTarget + "\" " + arguments : this.relativTarget + ' ' + arguments;
        this.workDir = workDir;
    }
}

