/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.image.icns;

import java.util.Arrays;

class RunLengthEncoding {
    private RunLengthEncoding() {
    }

    public static void unpackIconData(byte[] packedData, byte[] unpackedData) {
        int in = 0;
        int out = 0;
        while (in < packedData.length && out < unpackedData.length) {
            int header;
            if (((header = packedData[in++] & 0xFF) & 0x80) == 0) {
                int nbLiteralBytes = header + 1;
                System.arraycopy(packedData, in, unpackedData, out, nbLiteralBytes);
                in += nbLiteralBytes;
                out += nbLiteralBytes;
                continue;
            }
            int nbTimesToRepeat = header - 125;
            byte data = packedData[in++];
            Arrays.fill(unpackedData, out, out + nbTimesToRepeat, data);
            out += nbTimesToRepeat;
        }
    }

    public static byte[] packIconData(byte[] unpackedData) {
        byte[] resultBuffer = new byte[unpackedData.length + (unpackedData.length + 128) / 128];
        int resultSize = RunLengthEncoding.packIconData(unpackedData, resultBuffer);
        byte[] packedData = new byte[resultSize];
        System.arraycopy(resultBuffer, 0, packedData, 0, resultSize);
        return packedData;
    }

    public static int packIconData(byte[] unpackedData, byte[] packedData) {
        int in = 0;
        int out = 0;
        while (in < unpackedData.length) {
            int nbLiteralBytes;
            int nbBytesRead;
            int literalStart = in;
            byte data = unpackedData[in++];
            int nbRepeatedBytes = 0;
            for (nbBytesRead = 1; in < unpackedData.length && nbBytesRead < 128 && nbRepeatedBytes < 3; ++nbBytesRead) {
                byte nextData;
                nbRepeatedBytes = (nextData = unpackedData[in++]) == data ? (nbRepeatedBytes == 0 ? 2 : ++nbRepeatedBytes) : 0;
                data = nextData;
            }
            if (nbRepeatedBytes < 3) {
                nbLiteralBytes = nbBytesRead;
                nbRepeatedBytes = 0;
            } else {
                nbLiteralBytes = nbBytesRead - nbRepeatedBytes;
            }
            if (nbLiteralBytes > 0) {
                packedData[out++] = (byte)(nbLiteralBytes - 1);
                System.arraycopy(unpackedData, literalStart, packedData, out, nbLiteralBytes);
                out += nbLiteralBytes;
            }
            while (in < unpackedData.length && unpackedData[in] == data && nbRepeatedBytes < 130) {
                ++nbRepeatedBytes;
                ++in;
            }
            if (nbRepeatedBytes >= 3) {
                packedData[out++] = (byte)(nbRepeatedBytes + 125);
                packedData[out++] = data;
                continue;
            }
            in -= nbRepeatedBytes;
        }
        return out;
    }

    public static void unpackBits(byte[] packedData, byte[] unpackedData) {
        int in = 0;
        int out = 0;
        while (in < packedData.length) {
            byte header;
            if ((header = packedData[in++]) > 0) {
                int nbLiteralBytes = 1 + header;
                System.arraycopy(packedData, in, unpackedData, out, nbLiteralBytes);
                in += nbLiteralBytes;
                out += nbLiteralBytes;
                continue;
            }
            if (header >= 0 || header == -128) continue;
            int nbTimesToRepeat = 1 - header;
            byte data = packedData[in++];
            Arrays.fill(unpackedData, out, out + nbTimesToRepeat, data);
            out += nbTimesToRepeat;
        }
    }
}

