/*
 * Decompiled with CFR 0.152.
 */
package com.inet.gradle.setup.image.icns;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class IOSupport {
    public static final int LONG_INT_SIZE = 4;
    public static final int INT_SIZE = 2;

    private IOSupport() {
    }

    public static String readLiteralLongInt(InputStream inputStream) throws IOException {
        byte[] data = new byte[4];
        IOSupport.readFully(inputStream, data);
        return new String(data);
    }

    public static void writeLiteralLongInt(OutputStream outputStream, String s) throws IOException {
        byte[] bytes = s.getBytes();
        outputStream.write(bytes, 0, Math.min(4, bytes.length));
        if (bytes.length < 4) {
            int padding = 4 - bytes.length;
            for (int i = 0; i < padding; ++i) {
                outputStream.write(32);
            }
        }
    }

    public static int readLongInt(InputStream inputStream) throws IOException {
        byte[] data = new byte[4];
        IOSupport.readFully(inputStream, data);
        return ((data[0] & 0xFF) << 24) + ((data[1] & 0xFF) << 16) + ((data[2] & 0xFF) << 8) + (data[3] & 0xFF);
    }

    public static void writeLongInt(OutputStream outputStream, int i) throws IOException {
        outputStream.write((i & 0xFF000000) >> 24);
        outputStream.write((i & 0xFF0000) >> 16);
        outputStream.write((i & 0xFF00) >> 8);
        outputStream.write(i & 0xFF);
    }

    public static long readInt(InputStream inputStream) throws IOException {
        byte[] data = new byte[2];
        IOSupport.readFully(inputStream, data);
        return ((data[0] & 0xFF) << 8) + data[1];
    }

    public static void writeInt(OutputStream outputStream, int i) throws IOException {
        outputStream.write((i & 0xFF00) >> 8);
        outputStream.write(i & 0xFF);
    }

    public static void readFully(InputStream inputStream, byte[] b) throws IOException {
        int nbBytesActuallyRead;
        int nbBytesToRead = b.length;
        for (int nbBytesRead = 0; nbBytesRead < nbBytesToRead; nbBytesRead += nbBytesActuallyRead) {
            nbBytesActuallyRead = inputStream.read(b, nbBytesRead, nbBytesToRead - nbBytesRead);
            if (nbBytesActuallyRead >= 0) continue;
            throw new EOFException();
        }
    }

    public static void skip(InputStream inputStream, long nbBytesToSkip) throws IOException {
        long nbBytesActuallySkipped;
        for (long nbBytesSkipped = 0L; nbBytesSkipped < nbBytesToSkip; nbBytesSkipped += nbBytesActuallySkipped) {
            nbBytesActuallySkipped = inputStream.skip(nbBytesToSkip - nbBytesSkipped);
            if (nbBytesActuallySkipped >= 0L) continue;
            throw new EOFException();
        }
    }
}

